/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.Extension;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.Messages;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelExpAxis
extends Axis {
    @DataBoundConstructor
    public LabelExpAxis(String name, String values) {
        super(name, LabelExpAxis.getExprValues(values));
    }

    public LabelExpAxis(String name, List<String> values) {
        super(name, values);
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String getValuesString() {
        StringBuffer sb = new StringBuffer();
        for (String item : this.getValues()) {
            sb.append(item);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static List<String> getExprValues(String valuesString) {
        String[] exprs;
        LinkedList<String> expressions = new LinkedList<String>();
        for (String expr : exprs = valuesString.split("\n")) {
            expressions.add(Util.fixEmptyAndTrim((String)expr));
        }
        return expressions;
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Messages.LabelExpAxis_DisplayName();
        }

        public boolean isInstantiable() {
            Jenkins h = Jenkins.getInstance();
            return !h.getNodes().isEmpty() || !h.clouds.isEmpty();
        }
    }
}

