/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.Message;
import com.mathworks.ci.UseMatlabVersionBuildWrapper;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;

@Extension
public final class MatlabItemListener
extends ItemListener {
    private static final Map<String, Boolean> prjCheckMatlabAxis = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> prjCheckMatlabBuildWrapper = new HashMap<String, Boolean>();

    public void onLoaded() {
        this.checkItems(Jenkins.get().getItems());
    }

    public void onUpdated(Item item) {
        if (!(item instanceof MatrixProject)) {
            return;
        }
        this.checkSingleItem(item);
    }

    private void checkItems(List<TopLevelItem> items) {
        for (TopLevelItem item : items) {
            if (!(item instanceof MatrixProject)) continue;
            this.check((MatrixProject)item);
        }
    }

    private void checkSingleItem(Item item) {
        this.check((MatrixProject)item);
    }

    private void check(MatrixProject prj) {
        this.checkForAxis(prj);
        this.checkForBuildWrapper(prj);
    }

    private void checkForAxis(MatrixProject prj) {
        boolean checkForAxis = false;
        Collection configurations = prj.getActiveConfigurations();
        for (MatrixConfiguration conf : configurations) {
            String matlabAxisValue = (String)conf.getCombination().get((Object)Message.getValue("Axis.matlab.key"));
            if (matlabAxisValue == null) continue;
            checkForAxis = true;
            break;
        }
        prjCheckMatlabAxis.put(prj.getFullName(), checkForAxis);
    }

    private void checkForBuildWrapper(MatrixProject prj) {
        boolean checkForBuildWrapper = false;
        for (Object bWrapper : prj.getBuildWrappersList().toArray()) {
            if (!(bWrapper instanceof UseMatlabVersionBuildWrapper)) continue;
            checkForBuildWrapper = ((UseMatlabVersionBuildWrapper)((Object)bWrapper)).getMatlabInstallationName() != null;
            break;
        }
        prjCheckMatlabBuildWrapper.put(prj.getFullName(), checkForBuildWrapper);
    }

    public static boolean getMatlabAxisCheckForPrj(String prjName) {
        return prjCheckMatlabAxis.get(prjName) != null && prjCheckMatlabAxis.get(prjName) != false;
    }

    public static boolean getMatlabBuildWrapperCheckForPrj(String prjName) {
        return prjCheckMatlabBuildWrapper.get(prjName) != null && prjCheckMatlabBuildWrapper.get(prjName) != false;
    }
}

