/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.MatlabExecutionException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class MatlabCommandStepExecution
extends SynchronousNonBlockingStepExecution<Void>
implements MatlabBuild {
    private static final long serialVersionUID = 1957239693658914450L;
    private String command;
    private EnvVars env;

    public MatlabCommandStepExecution(StepContext context, String command) {
        super(context);
        this.command = command;
    }

    private String getCommand() {
        return this.env == null ? this.command : this.env.expand(this.command);
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    public Void run() throws Exception {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
        this.setEnv(env);
        workspace.mkdirs();
        int exitCode = this.execMatlabCommand(workspace, launcher, listener, env);
        if (exitCode != 0) {
            this.stop(new MatlabExecutionException(exitCode));
        }
        this.getContext().setResult(Result.SUCCESS);
        return null;
    }

    public void stop(Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueTmpFldrName = this.getUniqueNameForRunnerFile();
        String uniqueCommandFile = "command_" + this.getUniqueNameForRunnerFile().replaceAll("-", "_");
        FilePath uniqueTmpFolderPath = this.getFilePathForUniqueFolder(launcher, uniqueTmpFldrName, workspace);
        this.createMatlabScriptByName(uniqueTmpFolderPath, uniqueCommandFile, workspace, listener);
        try {
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, "cd('" + uniqueTmpFolderPath.getRemote().replaceAll("'", "''") + "'); " + uniqueCommandFile, uniqueTmpFldrName);
            listener.getLogger().println("#################### Starting command output ####################");
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        finally {
            if (uniqueTmpFolderPath.exists()) {
                uniqueTmpFolderPath.deleteRecursive();
            }
        }
    }

    private void createMatlabScriptByName(FilePath uniqeTmpFolderPath, String uniqueScriptName, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        FilePath matlabCommandFile = new FilePath(uniqeTmpFolderPath, uniqueScriptName + ".m");
        String matlabCommandFileContent = "cd '" + workspace.getRemote().replaceAll("'", "''") + "';\n" + this.getCommand();
        listener.getLogger().println("Generating MATLAB script with content:\n" + this.getCommand() + "\n");
        matlabCommandFile.write(matlabCommandFileContent, "UTF-8");
    }
}

