/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.freestyle;

import com.mathworks.ci.Message;
import com.mathworks.ci.actions.MatlabActionFactory;
import com.mathworks.ci.actions.RunMatlabCommandAction;
import com.mathworks.ci.freestyle.options.StartupOptions;
import com.mathworks.ci.parameters.CommandActionParameters;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class RunMatlabCommandBuilder
extends Builder
implements SimpleBuildStep {
    private transient int buildResult;
    private String matlabCommand;
    private StartupOptions startupOptions;
    private MatlabActionFactory factory;

    public RunMatlabCommandBuilder(MatlabActionFactory factory) {
        this.factory = factory;
    }

    @DataBoundConstructor
    public RunMatlabCommandBuilder() {
        this(new MatlabActionFactory());
    }

    @DataBoundSetter
    public void setMatlabCommand(String matlabCommand) {
        this.matlabCommand = matlabCommand;
    }

    @DataBoundSetter
    public void setStartupOptions(StartupOptions startupOptions) {
        this.startupOptions = startupOptions;
    }

    public String getMatlabCommand() {
        return this.matlabCommand;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public String getStartupOptionsAsString() {
        return this.startupOptions == null ? "" : this.startupOptions.getOptions();
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment(listener);
        CommandActionParameters params = new CommandActionParameters(build, workspace, env, launcher, listener, this.getStartupOptionsAsString(), this.getMatlabCommand());
        RunMatlabCommandAction action = this.factory.createAction(params);
        try {
            action.run();
        }
        catch (Exception e) {
            build.setResult(Result.FAILURE);
        }
    }

    protected Object readResolve() {
        if (this.factory == null) {
            this.factory = new MatlabActionFactory();
        }
        return this;
    }

    @Extension
    public static class RunMatlabCommandDescriptor
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabCommandBuilder", RunMatlabCommandBuilder.class);
        }

        public String getDisplayName() {
            return Message.getValue("Builder.script.builder.display.name");
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }

        @POST
        public FormValidation doCheckMatlabCommand(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.isEmpty()) {
                return FormValidation.error((String)Message.getValue("matlab.empty.command.error"));
            }
            return FormValidation.ok();
        }
    }
}

