/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci.freestyle;

import com.mathworks.ci.Message;
import com.mathworks.ci.actions.MatlabActionFactory;
import com.mathworks.ci.actions.RunMatlabBuildAction;
import com.mathworks.ci.freestyle.options.BuildOptions;
import com.mathworks.ci.freestyle.options.StartupOptions;
import com.mathworks.ci.parameters.BuildActionParameters;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class RunMatlabBuildBuilder
extends Builder
implements SimpleBuildStep {
    private transient int buildResult;
    private String tasks;
    private StartupOptions startupOptions;
    private BuildOptions buildOptions;
    private MatlabActionFactory factory;

    public RunMatlabBuildBuilder(MatlabActionFactory factory) {
        this.factory = factory;
    }

    @DataBoundConstructor
    public RunMatlabBuildBuilder() {
        this(new MatlabActionFactory());
    }

    @DataBoundSetter
    public void setTasks(String tasks) {
        this.tasks = tasks;
    }

    @DataBoundSetter
    public void setStartupOptions(StartupOptions startupOptions) {
        this.startupOptions = startupOptions;
    }

    @DataBoundSetter
    public void setBuildOptions(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    public String getTasks() {
        return this.tasks;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public String getStartupOptionsAsString() {
        return this.startupOptions == null ? "" : this.startupOptions.getOptions();
    }

    public BuildOptions getBuildOptions() {
        return this.buildOptions;
    }

    public String getBuildOptionsAsString() {
        return this.buildOptions == null ? null : this.buildOptions.getOptions();
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment(listener);
        BuildActionParameters params = new BuildActionParameters(build, workspace, env, launcher, listener, this.getStartupOptionsAsString(), this.getTasks(), this.getBuildOptionsAsString());
        RunMatlabBuildAction action = this.factory.createAction(params);
        try {
            action.run();
        }
        catch (Exception e) {
            build.setResult(Result.FAILURE);
        }
    }

    protected Object readResolve() {
        if (this.factory == null) {
            this.factory = new MatlabActionFactory();
        }
        return this;
    }

    @Extension
    public static class RunMatlabBuildDescriptor
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.mathworks.ci.RunMatlabBuildBuilder", RunMatlabBuildBuilder.class);
        }

        public String getDisplayName() {
            return Message.getValue("Builder.build.builder.display.name");
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }
    }
}

