/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.MatlabBuild;
import com.mathworks.ci.MatlabBuilderConstants;
import com.mathworks.ci.MatlabExecutionException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class MatlabRunTestsStepExecution
extends SynchronousNonBlockingStepExecution<Void>
implements MatlabBuild {
    private static final long serialVersionUID = 6704588180717665100L;
    private String commandArgs;
    private String startupOptions;

    public MatlabRunTestsStepExecution(StepContext context, String commandArgs, String startupOptions) {
        super(context);
        this.commandArgs = commandArgs;
        this.startupOptions = startupOptions;
    }

    private String getCommandArgs() {
        return this.commandArgs;
    }

    public Void run() throws Exception {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        EnvVars env = (EnvVars)this.getContext().get(EnvVars.class);
        workspace.mkdirs();
        int exitCode = this.execMatlabCommand(workspace, launcher, listener, env);
        if (exitCode != 0) {
            this.stop(new MatlabExecutionException(exitCode));
        }
        this.getContext().setResult(Result.SUCCESS);
        return null;
    }

    public void stop(Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        String uniqueMatlabResourceFldr = this.getUniqueNameForRunnerFile();
        try {
            FilePath genScriptLocation = this.getFilePathForUniqueFolder(launcher, uniqueMatlabResourceFldr, workspace);
            String cmdPrefix = "addpath('" + genScriptLocation.getRemote().replaceAll("'", "''") + "'); ";
            String matlabScriptName = this.getValidMatlabFileName(genScriptLocation.getBaseName());
            Launcher.ProcStarter matlabLauncher = this.getProcessToRunMatlabCommand(workspace, launcher, listener, envVars, cmdPrefix + matlabScriptName + ",delete('.matlab/" + genScriptLocation.getBaseName() + "/" + matlabScriptName + ".m'),runnerScript,rmdir(tmpDir,'s')", this.startupOptions, uniqueMatlabResourceFldr);
            this.prepareTmpFldr(genScriptLocation, this.getRunnerScript(MatlabBuilderConstants.TEST_RUNNER_SCRIPT, envVars.expand(this.getCommandArgs()), uniqueMatlabResourceFldr));
            int n = matlabLauncher.pwd(workspace).join();
            return n;
        }
        finally {
            FilePath matlabRunnerScript = this.getFilePathForUniqueFolder(launcher, uniqueMatlabResourceFldr, workspace);
            if (matlabRunnerScript.exists()) {
                matlabRunnerScript.deleteRecursive();
            }
        }
    }
}

