/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ci;

import com.mathworks.ci.ListenerLogDecorator;
import com.mathworks.ci.MatlabReleaseInfo;
import com.mathworks.ci.MatlabVersionNotFoundException;
import com.mathworks.ci.MatrixPatternResolver;
import com.mathworks.ci.Message;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class MatlabBuilder
extends Builder
implements SimpleBuildStep {
    private int buildResult;
    private TestRunTypeList testRunTypeList;
    private String matlabRoot;
    private EnvVars env;
    private MatlabReleaseInfo matlabRel;
    private String nodeSpecificfileSeparator;

    @DataBoundConstructor
    public MatlabBuilder() {
    }

    @DataBoundSetter
    public void setMatlabRoot(String matlabRoot) {
        this.matlabRoot = matlabRoot;
    }

    @DataBoundSetter
    public void setTestRunTypeList(TestRunTypeList testRunTypeList) {
        this.testRunTypeList = testRunTypeList;
    }

    public String getMatlabRoot() {
        return this.matlabRoot;
    }

    public TestRunTypeList getTestRunTypeList() {
        return this.testRunTypeList;
    }

    private String getLocalMatlab() {
        return this.env == null ? this.getMatlabRoot() : this.env.expand(this.getMatlabRoot());
    }

    private String getCustomMatlabCommand() {
        return this.env == null ? this.getTestRunTypeList().getStringByName("customMatlabCommand") : this.env.expand(this.getTestRunTypeList().getStringByName("customMatlabCommand"));
    }

    private void setEnv(EnvVars env) {
        this.env = env;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.setEnv(build.getEnvironment(listener));
        FilePath nodeSpecificMatlabRoot = new FilePath(launcher.getChannel(), this.getLocalMatlab());
        this.matlabRel = new MatlabReleaseInfo(nodeSpecificMatlabRoot);
        this.nodeSpecificfileSeparator = this.getNodeSpecificFileSeperator(launcher);
        this.buildResult = this.execMatlabCommand(workspace, launcher, listener);
        if (this.buildResult != 0) {
            build.setResult(Result.FAILURE);
        }
    }

    private synchronized int execMatlabCommand(FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        Launcher.ProcStarter matlabLauncher;
        try {
            matlabLauncher = launcher.launch().pwd(workspace).envs((Map)this.env);
            if (this.matlabRel.verLessThan(9.5)) {
                ListenerLogDecorator outStream = new ListenerLogDecorator(listener);
                matlabLauncher = matlabLauncher.cmds(this.constructDefaultMatlabCommand(launcher.isUnix())).stderr((OutputStream)((Object)outStream));
            } else {
                matlabLauncher = matlabLauncher.cmds(this.constructMatlabCommandWithBatch()).stdout(listener);
            }
            String testRunMode = this.getTestRunTypeList().getDescriptor().getId();
            if (testRunMode.contains("RunTestsAutomaticallyOption")) {
                FilePath targetWorkspace = new FilePath(launcher.getChannel(), workspace.getRemote());
                this.copyMatlabScratchFileInWorkspace("com/mathworks/ci/MatlabBuilder/runMatlabTests.m", "Builder.matlab.runner.target.file.name", targetWorkspace);
            }
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
            return 1;
        }
        return matlabLauncher.join();
    }

    public List<String> constructMatlabCommandWithBatch() {
        String runCommand;
        String testRunMode = this.getTestRunTypeList().getDescriptor().getId();
        if (testRunMode.contains("RunTestsAutomaticallyOption")) {
            String matlabFunctionName = FilenameUtils.removeExtension((String)Message.getValue("Builder.matlab.runner.target.file.name"));
            runCommand = "exit(" + matlabFunctionName + "(" + this.getInputArguments() + "))";
        } else {
            runCommand = this.getCustomMatlabCommand();
        }
        List<String> matlabDefaultArgs = Arrays.asList(this.getLocalMatlab() + this.nodeSpecificfileSeparator + "bin" + this.nodeSpecificfileSeparator + "matlab", "-batch", runCommand);
        return matlabDefaultArgs;
    }

    public List<String> constructDefaultMatlabCommand(boolean isLinuxLauncher) throws MatlabVersionNotFoundException {
        ArrayList<String> matlabDefaultArgs = new ArrayList<String>();
        Collections.addAll(matlabDefaultArgs, this.getPreRunnerSwitches());
        if (!isLinuxLauncher) {
            matlabDefaultArgs.add("-noDisplayDesktop");
        }
        Collections.addAll(matlabDefaultArgs, this.getRunnerSwitch());
        if (!isLinuxLauncher) {
            matlabDefaultArgs.add("-wait");
        }
        Collections.addAll(matlabDefaultArgs, this.getPostRunnerSwitches());
        return matlabDefaultArgs;
    }

    private String[] getPreRunnerSwitches() throws MatlabVersionNotFoundException {
        Object[] preRunnerSwitches = new String[]{this.getLocalMatlab() + this.nodeSpecificfileSeparator + "bin" + this.nodeSpecificfileSeparator + "matlab", "-nosplash", "-nodesktop"};
        if (!this.matlabRel.verLessThan(8.6)) {
            preRunnerSwitches = (String[])ArrayUtils.add((Object[])preRunnerSwitches, (Object)"-noAppIcon");
        }
        return preRunnerSwitches;
    }

    private String[] getPostRunnerSwitches() {
        String[] postRunnerSwitch = new String[]{"-log"};
        return postRunnerSwitch;
    }

    private String[] getRunnerSwitch() {
        String runCommand;
        String testRunMode = this.getTestRunTypeList().getDescriptor().getId();
        if (testRunMode.contains("RunTestsAutomaticallyOption")) {
            String matlabFunctionName = FilenameUtils.removeExtension((String)Message.getValue("Builder.matlab.runner.target.file.name"));
            runCommand = "try,exit(" + matlabFunctionName + "(" + this.getInputArguments() + ")),catch e,disp(getReport(e,'extended')),exit(1),end";
        } else {
            runCommand = "try,eval('" + this.getCustomMatlabCommand().replaceAll("'", "''") + "'),catch e,disp(getReport(e,'extended')),exit(1),end,exit";
        }
        String[] runnerSwitch = new String[]{"-r", runCommand};
        return runnerSwitch;
    }

    private void copyMatlabScratchFileInWorkspace(String matlabRunnerResourcePath, String matlabRunnerTarget, FilePath targetWorkspace) throws IOException, InterruptedException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        FilePath targetFile = new FilePath(targetWorkspace, Message.getValue(matlabRunnerTarget));
        InputStream in = classLoader.getResourceAsStream(matlabRunnerResourcePath);
        targetFile.copyFrom(in);
    }

    private String getNodeSpecificFileSeperator(Launcher launcher) {
        if (launcher.isUnix()) {
            return "/";
        }
        return "\\";
    }

    private String getInputArguments() {
        String pdfReport = "'PDFReport'," + this.getTestRunTypeList().getBooleanByName("taPDFReportChkBx");
        String tapResults = "'TAPResults'," + this.getTestRunTypeList().getBooleanByName("tatapChkBx");
        String junitResults = "'JUnitResults'," + this.getTestRunTypeList().getBooleanByName("taJunitChkBx");
        String stmResults = "'SimulinkTestResults'," + this.getTestRunTypeList().getBooleanByName("taSTMResultsChkBx");
        String coberturaCodeCoverage = "'CoberturaCodeCoverage'," + this.getTestRunTypeList().getBooleanByName("taCoberturaChkBx");
        String coberturaModelCoverage = "'CoberturaModelCoverage'," + this.getTestRunTypeList().getBooleanByName("taModelCoverageChkBx");
        String inputArgsToMatlabFcn = pdfReport + "," + tapResults + "," + junitResults + "," + stmResults + "," + coberturaCodeCoverage + "," + coberturaModelCoverage;
        return inputArgsToMatlabFcn;
    }

    public static class RunTestsWithCustomCommandOption
    extends TestRunTypeList {
        private String customMatlabCommand;

        @DataBoundConstructor
        public RunTestsWithCustomCommandOption() {
        }

        @DataBoundSetter
        public void setCustomMatlabCommand(String customMatlabCommand) {
            this.customMatlabCommand = customMatlabCommand;
        }

        public String getCustomMatlabCommand() {
            return this.customMatlabCommand;
        }

        @Override
        public boolean getBooleanByName(String memberName) {
            return false;
        }

        @Override
        public String getStringByName(String memberName) {
            switch (memberName) {
                case "customMatlabCommand": {
                    return this.getCustomMatlabCommand();
                }
            }
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends TestRunTypeDescriptor {
            public String getDisplayName() {
                return Message.getValue("builder.matlab.customcommandoption.display.name");
            }
        }
    }

    public static class RunTestsAutomaticallyOption
    extends TestRunTypeList {
        private boolean tatapChkBx;
        private boolean taJunitChkBx;
        private boolean taCoberturaChkBx;
        private boolean taSTMResultsChkBx;
        private boolean taModelCoverageChkBx;
        private boolean taPDFReportChkBx;

        @DataBoundConstructor
        public RunTestsAutomaticallyOption() {
        }

        @DataBoundSetter
        public void setTatapChkBx(boolean tatapChkBx) {
            this.tatapChkBx = tatapChkBx;
        }

        @DataBoundSetter
        public void setTaJunitChkBx(boolean taJunitChkBx) {
            this.taJunitChkBx = taJunitChkBx;
        }

        @DataBoundSetter
        public void setTaCoberturaChkBx(boolean taCoberturaChkBx) {
            this.taCoberturaChkBx = taCoberturaChkBx;
        }

        @DataBoundSetter
        public void setTaSTMResultsChkBx(boolean taSTMResultsChkBx) {
            this.taSTMResultsChkBx = taSTMResultsChkBx;
        }

        @DataBoundSetter
        public void setTaModelCoverageChkBx(boolean taModelCoverageChkBx) {
            this.taModelCoverageChkBx = taModelCoverageChkBx;
        }

        @DataBoundSetter
        public void setTaPDFReportChkBx(boolean taPDFReportChkBx) {
            this.taPDFReportChkBx = taPDFReportChkBx;
        }

        public boolean getTatapChkBx() {
            return this.tatapChkBx;
        }

        public boolean getTaJunitChkBx() {
            return this.taJunitChkBx;
        }

        public boolean getTaCoberturaChkBx() {
            return this.taCoberturaChkBx;
        }

        public boolean getTaSTMResultsChkBx() {
            return this.taSTMResultsChkBx;
        }

        public boolean getTaModelCoverageChkBx() {
            return this.taModelCoverageChkBx;
        }

        public boolean getTaPDFReportChkBx() {
            return this.taPDFReportChkBx;
        }

        @Override
        public boolean getBooleanByName(String memberName) {
            switch (memberName) {
                case "tatapChkBx": {
                    return this.getTatapChkBx();
                }
                case "taJunitChkBx": {
                    return this.getTaJunitChkBx();
                }
                case "taCoberturaChkBx": {
                    return this.getTaCoberturaChkBx();
                }
                case "taSTMResultsChkBx": {
                    return this.getTaSTMResultsChkBx();
                }
                case "taModelCoverageChkBx": {
                    return this.getTaModelCoverageChkBx();
                }
                case "taPDFReportChkBx": {
                    return this.getTaPDFReportChkBx();
                }
            }
            return false;
        }

        @Override
        public String getStringByName(String memberName) {
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends TestRunTypeDescriptor {
            public String getDisplayName() {
                return Message.getValue("builder.matlab.automatictestoption.display.name");
            }
        }
    }

    public static abstract class TestRunTypeDescriptor
    extends Descriptor<TestRunTypeList> {
        MatlabReleaseInfo rel;
        Function<String, FormValidation> chkCoberturaSupport = matlabRoot -> {
            FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
            this.rel = new MatlabReleaseInfo(matlabRootPath);
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    if (this.rel.verLessThan(9.3)) {
                        return FormValidation.warning((String)Message.getValue("Builder.matlab.cobertura.support.warning"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkModelCoverageSupport = matlabRoot -> {
            FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
            this.rel = new MatlabReleaseInfo(matlabRootPath);
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    if (this.rel.verLessThan(9.5)) {
                        return FormValidation.warning((String)Message.getValue("Builder.matlab.modelcoverage.support.warning"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkSTMResultsSupport = matlabRoot -> {
            FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
            this.rel = new MatlabReleaseInfo(matlabRootPath);
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    if (this.rel.verLessThan(9.6)) {
                        return FormValidation.warning((String)Message.getValue("Builder.matlab.exportstmresults.support.warning"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };

        public FormValidation doCheckTaCoberturaChkBx(@QueryParameter boolean taCoberturaChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            if (taCoberturaChkBx) {
                listOfCheckMethods.add(this.chkCoberturaSupport);
            }
            String matlabRoot = ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getMatlabRoot();
            return ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getFirstErrorOrWarning(listOfCheckMethods, matlabRoot);
        }

        public FormValidation doCheckTaModelCoverageChkBx(@QueryParameter boolean taModelCoverageChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            if (taModelCoverageChkBx) {
                listOfCheckMethods.add(this.chkModelCoverageSupport);
            }
            String matlabRoot = ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getMatlabRoot();
            return ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getFirstErrorOrWarning(listOfCheckMethods, matlabRoot);
        }

        public FormValidation doCheckTaSTMResultsChkBx(@QueryParameter boolean taSTMResultsChkBx) {
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            if (taSTMResultsChkBx) {
                listOfCheckMethods.add(this.chkSTMResultsSupport);
            }
            String matlabRoot = ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getMatlabRoot();
            return ((MatlabDescriptor)Jenkins.getInstance().getDescriptorByType(MatlabDescriptor.class)).getFirstErrorOrWarning(listOfCheckMethods, matlabRoot);
        }
    }

    public static abstract class TestRunTypeList
    implements ExtensionPoint,
    Describable<TestRunTypeList> {
        public abstract boolean getBooleanByName(String var1);

        public abstract String getStringByName(String var1);

        public Descriptor<TestRunTypeList> getDescriptor() {
            return Jenkins.getInstance().getDescriptor(this.getClass());
        }
    }

    @Extension
    public static class MatlabDescriptor
    extends BuildStepDescriptor<Builder> {
        MatlabReleaseInfo rel;
        String matlabRoot;
        Function<String, FormValidation> chkMatlabEmpty = matlabRoot -> {
            if (matlabRoot.isEmpty()) {
                return FormValidation.error((String)Message.getValue("Builder.matlab.root.empty.error"));
            }
            return FormValidation.ok();
        };
        Function<String, FormValidation> chkMatlabSupportsRunTests = matlabRoot -> {
            MatrixPatternResolver resolver = new MatrixPatternResolver((String)matlabRoot);
            if (!resolver.hasVariablePattern()) {
                try {
                    FilePath matlabRootPath = new FilePath(new File((String)matlabRoot));
                    this.rel = new MatlabReleaseInfo(matlabRootPath);
                    if (this.rel.verLessThan(8.1)) {
                        return FormValidation.error((String)Message.getValue("Builder.matlab.test.support.error"));
                    }
                }
                catch (MatlabVersionNotFoundException e) {
                    return FormValidation.warning((String)Message.getValue("Builder.invalid.matlab.root.warning"));
                }
            }
            return FormValidation.ok();
        };

        public String getMatlabRoot() {
            return this.matlabRoot;
        }

        public void setMatlabRoot(String matlabRoot) {
            this.matlabRoot = matlabRoot;
        }

        public String getDisplayName() {
            return "";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobtype) {
            return true;
        }

        public DescriptorExtensionList<TestRunTypeList, Descriptor<TestRunTypeList>> getTestRunTypeDescriptor() {
            return Jenkins.getInstance().getDescriptorList(TestRunTypeList.class);
        }

        @POST
        public FormValidation doCheckMatlabRoot(@QueryParameter String matlabRoot, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            this.setMatlabRoot(matlabRoot);
            ArrayList<Function<String, FormValidation>> listOfCheckMethods = new ArrayList<Function<String, FormValidation>>();
            listOfCheckMethods.add(this.chkMatlabEmpty);
            listOfCheckMethods.add(this.chkMatlabSupportsRunTests);
            return this.getFirstErrorOrWarning(listOfCheckMethods, matlabRoot);
        }

        public FormValidation getFirstErrorOrWarning(List<Function<String, FormValidation>> validations, String matlabRoot) {
            if (validations == null || validations.isEmpty()) {
                return FormValidation.ok();
            }
            for (Function<String, FormValidation> val : validations) {
                FormValidation validationResult = val.apply(matlabRoot);
                if (validationResult.kind.compareTo((Enum)FormValidation.Kind.ERROR) != 0 && validationResult.kind.compareTo((Enum)FormValidation.Kind.WARNING) != 0) continue;
                return validationResult;
            }
            return FormValidation.ok();
        }
    }
}

