/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.scripts;

import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.mantis.scripts.ScriptContent;
import hudson.plugins.mantis.scripts.ScriptContentBuildWrapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.InputSource;

public class JellyScriptContent
implements ScriptContent {
    private static final int BUFFER_SIZE = 16384;
    private static final Logger LOGGER = Logger.getLogger(JellyScriptContent.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContent(AbstractBuild<?, ?> build, Result result) throws IOException, InterruptedException {
        InputStream inputStream = null;
        String templateName = result.toString().toLowerCase();
        try {
            inputStream = this.getTemplateInputStream(templateName);
            String string = this.renderContent(build, inputStream);
            return string;
        }
        catch (JellyException e) {
            LOGGER.log(Level.WARNING, "failed to parse jelly template.", e);
            String string = "JellyException: " + e.getMessage();
            return string;
        }
        catch (FileNotFoundException e) {
            String missingTemplateError;
            String string = missingTemplateError = this.generateMissingTemplate(templateName);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private String generateMissingTemplate(String template) {
        return "Jelly script [" + template + "] was not found";
    }

    private InputStream getTemplateInputStream(String templateName) throws FileNotFoundException {
        File templatesFolder = new File(Hudson.getInstance().getRootDir(), "mantis/scripts/templates/descriptions");
        File templateFile = new File(templatesFolder, templateName + ".jelly");
        if (templateFile.exists()) {
            return new FileInputStream(templateFile);
        }
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("hudson/plugins/mantis/scripts/templates/descriptions/" + templateName + ".jelly");
        return inputStream;
    }

    private String renderContent(AbstractBuild<?, ?> build, InputStream inputStream) throws JellyException, IOException {
        JellyContext context = this.createContext(new ScriptContentBuildWrapper(build), build);
        Script script = context.compileScript(new InputSource(inputStream));
        if (script != null) {
            return this.convert(context, script);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convert(JellyContext context, Script script) throws JellyTagException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(16384);
        XMLOutput xmlOutput = null;
        try {
            xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
            script.run(context, xmlOutput);
            xmlOutput.flush();
        }
        finally {
            try {
                if (xmlOutput != null) {
                    xmlOutput.close();
                }
            }
            finally {
                output.close();
            }
        }
        return output.toString();
    }

    private JellyContext createContext(Object it, AbstractBuild<?, ?> build) {
        JellyContext context = new JellyContext();
        context.setVariable("it", it);
        context.setVariable("build", build);
        context.setVariable("project", (Object)build.getParent());
        context.setVariable("rooturl", (Object)Hudson.getInstance().getRootUrl());
        return context;
    }
}

