/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis.changeset;

import hudson.model.AbstractBuild;
import hudson.plugins.mantis.changeset.AbstractChangeSet;
import hudson.plugins.mantis.changeset.ChangeSetUtil;
import hudson.plugins.mantis.changeset.Messages;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.EditType;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CVSChangeSet
extends AbstractChangeSet<CVSChangeLogSet.CVSChangeLog> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CVSChangeLogSet.class.getName());

    public CVSChangeSet(int id, AbstractBuild<?, ?> build, CVSChangeLogSet.CVSChangeLog entry) {
        super(id, build, entry);
    }

    @Override
    public String createChangeLog() {
        StringBuilder text = new StringBuilder();
        text.append(Messages.ChangeSet_Author(this.getAuthor()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_Log(this.getMsg()));
        text.append(CRLF);
        text.append(Messages.ChangeSet_ChangedPaths_Header());
        text.append(CRLF);
        for (AffectedPath path : this.getAffectedPaths()) {
            text.append(Messages.ChangeSet_ChangedPaths_CVS_Path(path.getMark(), path.getRevision(), path.getPath(), path.getDiffLink()));
            text.append(CRLF);
        }
        text.append(CRLF);
        return text.toString();
    }

    @Override
    protected String getChangeSetLink() {
        return "";
    }

    private List<AffectedPath> getAffectedPaths() {
        ArrayList<AffectedPath> paths = new ArrayList<AffectedPath>();
        CVSRepositoryBrowser browser = (CVSRepositoryBrowser)this.getRepositoryBrowser();
        for (CVSChangeLogSet.File file : ((CVSChangeLogSet.CVSChangeLog)this.entry).getFiles()) {
            paths.add(new AffectedPath(file, browser));
        }
        return paths;
    }

    private static class AffectedPath {
        private final CVSChangeLogSet.File file;
        private final CVSRepositoryBrowser browser;

        public AffectedPath(CVSChangeLogSet.File file, CVSRepositoryBrowser browser) {
            this.file = file;
            this.browser = browser;
        }

        public String getMark() {
            EditType type = this.file.getEditType();
            return ChangeSetUtil.getEditTypeMark(type);
        }

        public String getPath() {
            return this.file.getFullName();
        }

        public String getRevision() {
            return this.file.getPrevrevision();
        }

        public String getDiffLink() {
            if (this.browser == null) {
                return "";
            }
            URL link = null;
            try {
                link = this.browser.getDiffLink(this.file);
            }
            catch (IOException e) {
                LOGGER.warning(e.getMessage());
            }
            if (link == null) {
                return "";
            }
            return link.toExternalForm();
        }
    }
}

