/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import java.io.PrintStream;
import java.util.Arrays;

public final class Utility {
    private static final char[] REGEXP_CHARS = new char[]{'\\', '[', ']', '(', ')', '{', '}', '^', '$', '|', '?', '*', '+', '-', ':', ',', '.', '&'};

    private Utility() {
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        block7: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    if (i < len - 1 && str.charAt(i + 1) == '#') {
                        buf.append(c);
                        continue block7;
                    }
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&#039;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static void log(PrintStream logger, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("[MANTIS] ").append(message);
        logger.println(buf.toString());
    }

    public static String escapeRegexp(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Arrays.binarySearch(REGEXP_CHARS, c) >= 0) {
                buf.append("\\");
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static {
        Arrays.sort(REGEXP_CHARS);
    }
}

