/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.plugins.mantis.MantisBuildAction;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@Extension
public final class MantisLinkAnnotator
extends ChangeLogAnnotator {
    private static final Logger LOGGER = Logger.getLogger(MantisLinkAnnotator.class.getName());

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        MantisProjectProperty mpp = MantisProjectProperty.get(build);
        if (mpp == null || mpp.getSite() == null) {
            return;
        }
        if (!mpp.isLinkEnabled()) {
            return;
        }
        MantisBuildAction action = (MantisBuildAction)build.getAction(MantisBuildAction.class);
        String url = mpp.getSite().getUrl().toExternalForm();
        Pattern pattern = this.findRegexPattern(action, mpp);
        for (MarkupText.SubText st : text.findTokens(pattern)) {
            int id;
            try {
                id = Integer.valueOf(st.group(1));
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, Messages.MantisLinkAnnotator_IllegalMantisId(st.group(1)));
                continue;
            }
            MantisIssue issue = action != null ? action.getIssue(id) : this.getIssue(build, id);
            String newUrl = Util.encode((String)(url + "view.php?id=$1"));
            if (issue == null) {
                LOGGER.log(Level.WARNING, Messages.MantisLinkAnnotator_FailedToGetMantisIssue(id));
                st.surroundWith(String.format("<a href='%s'>", newUrl), "</a>");
                continue;
            }
            String summary = Utility.escape(issue.getSummary());
            st.surroundWith(String.format("<a href='%s' tooltip='%s'>", newUrl, summary), "</a>");
        }
    }

    private Pattern findRegexPattern(MantisBuildAction action, MantisProjectProperty mpp) {
        Pattern pattern = null;
        if (action != null) {
            pattern = action.getPattern();
        }
        if (pattern == null) {
            pattern = mpp.getRegexpPattern();
        }
        return pattern;
    }

    private MantisIssue getIssue(AbstractBuild<?, ?> build, int id) {
        MantisIssue issue;
        MantisSite site = MantisSite.get(build.getProject());
        try {
            issue = site.getIssue(id);
        }
        catch (MantisHandlingException e) {
            issue = null;
        }
        return issue;
    }
}

