/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.mantis.MantisHandlingException;
import hudson.plugins.mantis.MantisProjectProperty;
import hudson.plugins.mantis.MantisRegisterAction;
import hudson.plugins.mantis.MantisSite;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.Utility;
import hudson.plugins.mantis.model.MantisCategory;
import hudson.plugins.mantis.model.MantisIssue;
import hudson.plugins.mantis.model.MantisProject;
import hudson.plugins.mantis.model.MantisViewState;
import hudson.plugins.mantis.scripts.JellyScriptContent;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public final class MantisIssueRegister
extends Recorder {
    private String threshold;
    private boolean keepTicketPrivate;
    public static final String FAILURE = "failure";
    public static final String FAILUREORUNSTABL = "failureOrUnstable";
    private static final Logger LOGGER = Logger.getLogger(MantisIssueRegister.class.getName());

    @DataBoundConstructor
    public MantisIssueRegister(String threshold, boolean keepTicketPrivate) {
        this.threshold = Util.fixEmptyAndTrim((String)threshold);
        this.keepTicketPrivate = keepTicketPrivate;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public boolean isKeepTicketPrivate() {
        return this.keepTicketPrivate;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        int no;
        PrintStream logger = listener.getLogger();
        if (!this.canProcess(build)) {
            return true;
        }
        MantisSite site = MantisSite.get(build.getProject());
        if (site == null) {
            Utility.log(logger, Messages.MantisIssueRegister_NoMantisSite());
            build.setResult(Result.FAILURE);
            return true;
        }
        MantisIssue issue = this.createIssue(build, listener);
        if (issue == null) {
            Utility.log(logger, "skipping file a ticket ...");
            return true;
        }
        try {
            no = site.addIssue(issue);
            Utility.log(logger, "file a ticket #" + no + "(" + this.getIssueURL(site, no) + ")");
        }
        catch (MantisHandlingException e) {
            Utility.log(logger, e.toString());
            build.setResult(Result.FAILURE);
            return true;
        }
        build.getActions().add(new MantisRegisterAction(site, no));
        return true;
    }

    private boolean canProcess(AbstractBuild<?, ?> build) {
        Result result = build.getResult();
        if (FAILURE.equals(this.threshold) && result.isBetterThan(Result.FAILURE)) {
            return false;
        }
        return !FAILUREORUNSTABL.equals(this.threshold) || !result.isBetterThan(Result.UNSTABLE);
    }

    private String getIssueURL(MantisSite site, int no) {
        return site.getIssueLink(no);
    }

    private MantisIssue createIssue(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        MantisProjectProperty mpp = MantisProjectProperty.get(build);
        int projectId = mpp.getProjectId();
        String categoryName = mpp.getCategory();
        if (projectId == -1 || "Not Selected".equals(categoryName)) {
            Utility.log(listener.getLogger(), "Neither project nor category selected.");
            return null;
        }
        MantisProject project = new MantisProject(projectId);
        MantisCategory category = new MantisCategory(categoryName);
        String summary = this.summary(build);
        String description = new JellyScriptContent().getContent(build, build.getResult());
        MantisViewState viewState = this.isKeepTicketPrivate() ? MantisViewState.PUBLIC : MantisViewState.PRIVATE;
        return new MantisIssue(project, category, summary, description, viewState);
    }

    private String summary(AbstractBuild<?, ?> build) {
        StringBuilder summary = new StringBuilder();
        summary.append(((AbstractProject)build.getParent()).getName());
        summary.append(" build No." + build.getNumber());
        summary.append(" " + build.getResult().toString());
        return summary.toString();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(MantisIssueRegister.class);
        }

        public String getDisplayName() {
            return Messages.MantisIssueRegister_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

