/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mantis;

import hudson.model.Action;
import hudson.plugins.mantis.Messages;
import hudson.plugins.mantis.model.MantisIssue;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class MantisBuildAction
implements Action {
    private static final long serialVersionUID = 1L;
    private final MantisIssue[] issues;
    private final Pattern pattern;

    public MantisIssue[] getIssues() {
        return Arrays.copyOf(this.issues, this.issues.length);
    }

    public MantisBuildAction(Pattern pattern, MantisIssue[] issues) {
        this.pattern = pattern;
        if (issues == null) {
            throw new IllegalArgumentException("issues should not be null.");
        }
        this.issues = Arrays.copyOf(issues, issues.length);
    }

    public String getDisplayName() {
        return Messages.MantiBuildAction_Displayname();
    }

    public String getUrlName() {
        return "mantis";
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public MantisIssue getIssue(int id) {
        for (MantisIssue issue : this.issues) {
            if (issue.getId() != id) continue;
            return issue;
        }
        return null;
    }

    public String getIconFileName() {
        return null;
    }
}

