/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.utils;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.impl.client.HttpClientBuilder;

public class SSLHelper {
    public static void setClientBuilderSSLContext(HttpClientBuilder clientBuilder, KeyStore customKeyStore) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, KeyManagementException {
        if (customKeyStore == null) {
            return;
        }
        String alias = customKeyStore.aliases().nextElement();
        X509Certificate certificate = (X509Certificate)customKeyStore.getCertificate(alias);
        if (certificate != null) {
            clientBuilder.setSslcontext(SSLHelper.createSSLContext(alias, certificate));
        }
    }

    public static SSLContext createSSLContext(String alias, X509Certificate certificate) throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException, KeyManagementException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager defaultTM = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTM = (X509TrustManager)tm;
            break;
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setEntry(alias, new KeyStore.TrustedCertificateEntry(certificate), null);
        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager customTM = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            customTM = (X509TrustManager)tm;
            break;
        }
        final X509TrustManager finalDefaultTM = defaultTM;
        final X509TrustManager finalCustomTM = customTM;
        X509TrustManager combinedTM = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return finalDefaultTM.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    finalCustomTM.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    finalDefaultTM.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                finalDefaultTM.checkClientTrusted(chain, authType);
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{combinedTM}, null);
        return sslContext;
    }
}

