/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.pipeline;

import com.google.common.util.concurrent.FutureCallback;
import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.YesNoMaybe;
import jenkins.plugins.logstash.LogstashConsoleLogFilter;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogstashStep
extends Step {
    @DataBoundConstructor
    public LogstashStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    @Extension(dynamicLoadable=YesNoMaybe.YES, optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Send individual log lines to Logstash";
        }

        public String getFunctionName() {
            return "logstash";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet<Class<Run>> contexts = new HashSet<Class<Run>>();
            contexts.add(Run.class);
            return contexts;
        }
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        public Execution(StepContext context) {
            super(context);
        }

        public void onResume() {
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            context.newBodyInvoker().withContext((Object)this.createConsoleLogFilter(context)).withCallback(BodyExecutionCallback.wrap((FutureCallback)context)).start();
            return false;
        }

        private ConsoleLogFilter createConsoleLogFilter(StepContext context) throws IOException, InterruptedException {
            ConsoleLogFilter original = (ConsoleLogFilter)context.get(ConsoleLogFilter.class);
            Run build = (Run)context.get(Run.class);
            LogstashConsoleLogFilter subsequent = new LogstashConsoleLogFilter(build);
            return BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)original, (ConsoleLogFilter)subsequent);
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }
    }
}

