/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.persistence;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import jenkins.plugins.logstash.persistence.HostBasedLogstashIndexerDao;
import org.apache.commons.lang.StringUtils;

public class RabbitMqDao
extends HostBasedLogstashIndexerDao {
    private final ConnectionFactory pool;
    private final String queue;
    private final String username;
    private final String password;
    private final Charset charset;
    private final String virtualHost;

    public RabbitMqDao(String host, int port, String key, String username, String password, Charset charset, String virtualHost) {
        this(null, host, port, key, username, password, charset, virtualHost);
    }

    RabbitMqDao(ConnectionFactory factory, String host, int port, String queue, String username, String password, Charset charset, String vhost) {
        super(host, port);
        this.queue = queue;
        this.username = username;
        this.password = password;
        this.charset = charset;
        this.virtualHost = vhost;
        if (StringUtils.isBlank((String)queue)) {
            throw new IllegalArgumentException("rabbit queue name is required");
        }
        this.pool = factory == null ? new ConnectionFactory() : factory;
        this.pool.setHost(host);
        this.pool.setPort(port);
        if (this.virtualHost != null) {
            this.pool.setVirtualHost(this.virtualHost);
        }
        if (!StringUtils.isBlank((String)username) && !StringUtils.isBlank((String)password)) {
            this.pool.setPassword(password);
            this.pool.setUsername(username);
        }
    }

    public String getQueue() {
        return this.queue;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(String data) throws IOException {
        Connection connection = null;
        Channel channel = null;
        try {
            connection = this.pool.newConnection();
            channel = connection.createChannel();
            try {
                channel.queueDeclarePassive(this.queue);
            }
            catch (IOException e) {
                this.finalizeChannel(channel);
                channel = connection.createChannel();
                channel.queueDeclare(this.queue, true, false, false, null);
            }
            channel.basicPublish("", this.queue, null, data.getBytes(this.charset));
            this.finalizeChannel(channel);
            this.finalizeConnection(connection);
        }
        catch (Throwable throwable) {
            this.finalizeChannel(channel);
            this.finalizeConnection(connection);
            throw throwable;
        }
    }

    private void finalizeConnection(Connection connection) {
        if (connection != null && connection.isOpen()) {
            try {
                connection.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void finalizeChannel(Channel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

