/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash.configuration;

import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.plugins.logstash.Messages;
import jenkins.plugins.logstash.configuration.HostBasedLogstashIndexer;
import jenkins.plugins.logstash.configuration.LogstashIndexer;
import jenkins.plugins.logstash.persistence.RedisDao;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class Redis
extends HostBasedLogstashIndexer<RedisDao> {
    protected String key;
    protected Secret password;

    @DataBoundConstructor
    public Redis() {
    }

    public String getKey() {
        return this.key;
    }

    @DataBoundSetter
    public void setKey(String key) {
        this.key = key;
    }

    public String getPassword() {
        return Secret.toString((Secret)this.password);
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = Secret.fromString((String)password);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Redis other = (Redis)((Object)obj);
        if (!Secret.toString((Secret)this.password).equals(other.getPassword())) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + Secret.toString((Secret)this.password).hashCode();
        return result;
    }

    @Override
    public RedisDao createIndexerInstance() {
        return new RedisDao(this.getHost(), this.getPort(), this.key, Secret.toString((Secret)this.password));
    }

    @Extension
    @Symbol(value={"redis"})
    public static class RedisDescriptor
    extends LogstashIndexer.LogstashIndexerDescriptor {
        public String getDisplayName() {
            return "Redis";
        }

        @Override
        public int getDefaultPort() {
            return 6379;
        }

        public FormValidation doCheckKey(@QueryParameter(value="value") String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)Messages.ValueIsRequired());
            }
            return FormValidation.ok();
        }
    }
}

