/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.logstash;

import hudson.console.ConsoleNote;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jenkins.plugins.logstash.LogstashWriter;

public class LogstashOutputStream
extends LineTransformationOutputStream {
    private final OutputStream delegate;
    private final LogstashWriter logstash;

    public LogstashOutputStream(OutputStream delegate, LogstashWriter logstash) {
        this.delegate = delegate;
        this.logstash = logstash;
    }

    LogstashWriter getLogstashWriter() {
        return this.logstash;
    }

    protected void eol(byte[] b, int len) throws IOException {
        this.delegate.write(b, 0, len);
        this.flush();
        if (!this.logstash.isConnectionBroken()) {
            String line = new String(b, 0, len, this.logstash.getCharset());
            line = ConsoleNote.removeNotes((String)line).trim();
            this.logstash.write(line);
        }
    }

    public void flush() throws IOException {
        this.delegate.flush();
        super.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }
}

