/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.logparser;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Run;
import hudson.plugins.logparser.LogParserResult;
import hudson.util.Area;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class LogParserAction
implements Action {
    private final Run<?, ?> build;
    private final LogParserResult result;
    private static String urlName = "parsed_console";

    @Deprecated
    public LogParserAction(AbstractBuild<?, ?> build, LogParserResult result) {
        this((Run<?, ?>)build, result);
    }

    public LogParserAction(Run<?, ?> build, LogParserResult result) {
        this.build = build;
        this.result = result;
    }

    public String getIconFileName() {
        return "clipboard.gif";
    }

    public String getDisplayName() {
        return "Parsed Console Output";
    }

    public String getUrlName() {
        return urlName;
    }

    public static String getUrlNameStat() {
        return urlName;
    }

    public Run<?, ?> getOwner() {
        return this.build;
    }

    public LogParserResult getResult() {
        return this.result;
    }

    public LogParserAction getPreviousAction() {
        LogParserAction action;
        Run build = this.getOwner();
        do {
            if ((build = build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (LogParserAction)build.getAction(LogParserAction.class)) == null);
        return action;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        String dir = this.result.getHtmlLogPath();
        String file = req.getRestOfPath();
        String[] fileArray = file.split("/");
        String lastFileInPath = fileArray[fileArray.length - 1];
        File f = new File(dir + "/" + lastFileInPath);
        rsp.serveFile(req, f.toURI().toURL());
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        if (req.checkIfModified(this.getOwner().getTimestamp(), rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(req, this.buildDataSet()), (Area)this.calcDefaultSize());
    }

    public void doGraphMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.checkIfModified(this.getOwner().getTimestamp(), rsp)) {
            return;
        }
        ChartUtil.generateClickableMap((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(req, this.buildDataSet()), (Area)this.calcDefaultSize());
    }

    private Area calcDefaultSize() {
        Area res = Functions.getScreenResolution();
        if (res != null && res.width <= 800) {
            return new Area(250, 100);
        }
        return new Area(500, 200);
    }

    private CategoryDataset buildDataSet() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (LogParserAction a = this; a != null; a = a.getPreviousAction()) {
            dsb.add((Number)a.result.getTotalErrors(), (Comparable)((Object)"errors"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.getOwner()));
            dsb.add((Number)a.result.getTotalWarnings(), (Comparable)((Object)"warnings"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.getOwner()));
            dsb.add((Number)a.result.getTotalInfos(), (Comparable)((Object)"infos"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(a.getOwner()));
        }
        return dsb.build();
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset) {
        final String relPath = this.getRelPath(req);
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2(){
            private static final long serialVersionUID = 1L;

            public String generateURL(CategoryDataset dataset, int row, int column) {
                ChartUtil.NumberOnlyBuildLabel label = (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
                return relPath + label.build.getNumber() + "/testReport/";
            }

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                switch (row) {
                    case 0: {
                        return "Errors: " + LogParserAction.this.result.getTotalErrors();
                    }
                    case 1: {
                        return "Warnings: " + LogParserAction.this.result.getTotalWarnings();
                    }
                }
                return "Infos: " + LogParserAction.this.result.getTotalInfos();
            }
        };
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        ar.setSeriesPaint(2, (Paint)ColorPalette.YELLOW);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private String getRelPath(StaplerRequest req) {
        String relPath = req.getParameter("rel");
        if (relPath == null) {
            return "";
        }
        return relPath;
    }
}

