/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.commands;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.AbstractProject;
import org.jenkinsci.plugins.commands.Messages;
import org.jenkinsci.plugins.commands.SLC;
import org.jenkinsci.plugins.commands.WrongBuildNumberException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class ShowLogCommand
extends CLICommand {
    private final int NOBUILD_ERRORCODE = 1;
    private CmdLineParser cmdLineParser = new CmdLineParser((Object)this);
    @Argument(required=true, usage="Name of the job to get the log", metaVar="JOB")
    private AbstractProject<?, ?> job;
    @Option(name="-nLines", aliases={"-n"}, usage="Max. number of log lines to show (default=10)")
    private int maxLines = 10;
    @Option(name="-bNumber", aliases={"-b"}, usage="Number of the build to get the log (default=last build)")
    private int buildNumber = -1;

    public String getShortDescription() {
        return Messages.ShowLogCommand();
    }

    protected int getBuildNumber() {
        return this.buildNumber;
    }

    protected int getMaxLines() {
        return this.maxLines;
    }

    protected AbstractProject<?, ?> getJob() {
        return this.job;
    }

    protected int run() throws Exception {
        try {
            this.stdout.println(SLC.showLog(this.job, this.buildNumber, this.maxLines));
        }
        catch (WrongBuildNumberException e) {
            this.stderr.println(e.getMessage());
            this.printUsage(this.stderr, this.cmdLineParser);
            return 1;
        }
        return 0;
    }
}

