/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.commands;

import hudson.Extension;
import hudson.plugins.im.Sender;
import hudson.plugins.im.bot.AbstractTextSendingCommand;
import hudson.plugins.im.bot.Bot;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jenkinsci.plugins.commands.Messages;
import org.jenkinsci.plugins.commands.SLC;
import org.jenkinsci.plugins.commands.ShowLogCommand;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(optional=true)
public class ShowLogIMCommand
extends AbstractTextSendingCommand {
    private CmdLineParser parser;

    protected String getReply(Bot bot, Sender sender, String[] args) {
        ShowLogCommand sCommand = new ShowLogCommand();
        this.parser = new CmdLineParser((Object)sCommand);
        String[] argsToParser = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        try {
            this.parser.parseArgument(argsToParser);
        }
        catch (CmdLineException e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.parser.printSingleLineUsage((OutputStream)baos);
            return this.getUsageCommandName() + " " + baos.toString();
        }
        return SLC.showLog(sCommand.getJob(), sCommand.getBuildNumber(), sCommand.getMaxLines());
    }

    private String getUsageCommandName() {
        Collection<String> cNames = this.getCommandNames();
        if (cNames.size() == 1) {
            return cNames.iterator().next();
        }
        String uCn = "{";
        Iterator<String> iterator = cNames.iterator();
        for (String name : cNames) {
            uCn = uCn + name + " | ";
        }
        uCn = uCn.substring(0, uCn.lastIndexOf(124)) + "}";
        return uCn;
    }

    public Collection<String> getCommandNames() {
        return Arrays.asList("show-log", "sl");
    }

    public String getHelp() {
        return " - " + Messages.ShowLogCommand();
    }
}

