/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.plugins.libvirt.lib.IConnect;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.plugins.libvirt.lib.jlibvirt.JLibVirtConnectImpl;
import hudson.plugins.libvirt.lib.libvirt.LibVirtConnectImpl;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ConnectionBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionBuilder.class.getName());
    private boolean useNativeJava = false;
    private String uri;
    private boolean readOnly = false;
    private String hypervisorType;
    private String userName;
    private String hypervisorHost;
    private int hypervisorPort = 22;
    private String hypervisorSysUrl;
    private StandardUsernameCredentials credentials;

    public static ConnectionBuilder newBuilder() {
        return new ConnectionBuilder();
    }

    public ConnectionBuilder hypervisorType(String type) {
        this.hypervisorType = type;
        return this;
    }

    public ConnectionBuilder userName(String user) {
        this.userName = user;
        return this;
    }

    public ConnectionBuilder hypervisorHost(String host) {
        this.hypervisorHost = host;
        return this;
    }

    public ConnectionBuilder hypervisorPort(int port) {
        this.hypervisorPort = port;
        return this;
    }

    public ConnectionBuilder hypervisorSysUrl(String sysUrl) {
        this.hypervisorSysUrl = sysUrl;
        return this;
    }

    public ConnectionBuilder withCredentials(StandardUsernameCredentials standardUsernameCredentials) {
        this.credentials = standardUsernameCredentials;
        return this;
    }

    public ConnectionBuilder useUri(String newuri) {
        this.uri = newuri;
        return this;
    }

    public ConnectionBuilder readOnly() {
        this.readOnly = true;
        return this;
    }

    public ConnectionBuilder useNativeJava(boolean b) {
        this.useNativeJava = b;
        return this;
    }

    public IConnect build() throws VirtException {
        if (this.useNativeJava) {
            if (this.uri == null) {
                this.uri = this.constructNativeHypervisorURI();
            }
            StandardUsernamePasswordCredentials standardUsernamePasswordCredentials = (StandardUsernamePasswordCredentials)this.credentials;
            return new JLibVirtConnectImpl(this.hypervisorHost, this.hypervisorPort, this.credentials.getUsername(), standardUsernamePasswordCredentials.getPassword().getPlainText(), this.uri, this.readOnly);
        }
        if (this.uri == null) {
            this.uri = this.constructHypervisorURI();
        }
        return new LibVirtConnectImpl(this.uri, this.readOnly);
    }

    public String constructHypervisorURI() {
        String url = this.hypervisorType.toLowerCase() + "://";
        if (this.userName != null && !this.userName.isEmpty()) {
            url = url + this.userName + "@";
        }
        url = url + this.hypervisorHost;
        if (this.hypervisorPort != 0) {
            url = url + ":" + this.hypervisorPort;
        }
        if (this.hypervisorSysUrl != null && !this.hypervisorSysUrl.isEmpty()) {
            url = url + "/" + this.hypervisorSysUrl;
        }
        LogRecord rec = new LogRecord(Level.INFO, "hypervisor: {0}");
        rec.setParameters(new Object[]{url});
        LOGGER.log(rec);
        return url;
    }

    public String constructNativeHypervisorURI() {
        String url = this.hypervisorType.toLowerCase() + ":///" + this.hypervisorSysUrl;
        LogRecord rec = new LogRecord(Level.INFO, "nativeHypervisor: {0}");
        rec.setParameters(new Object[]{url});
        LOGGER.log(rec);
        return url;
    }
}

