/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import com.google.common.collect.Collections2;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.Messages;
import hudson.plugins.libvirt.PluginImpl;
import hudson.plugins.libvirt.VirtualMachineManagementServer;
import java.io.IOException;
import java.util.Collection;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerProxy;

@Extension
public class VirtualMachineManagement
extends ManagementLink
implements StaplerProxy,
Describable<VirtualMachineManagement>,
Saveable {
    public String getIconFileName() {
        return "/plugin/libvirt-slave/images//64x64/libvirt.png";
    }

    public String getUrlName() {
        return "libvirt-slave";
    }

    public String getDisplayName() {
        return Messages.DisplayName();
    }

    public String getDescription() {
        return Messages.PluginDescription();
    }

    public static VirtualMachineManagement get() {
        return (VirtualMachineManagement)((Object)ManagementLink.all().get(VirtualMachineManagement.class));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    public VirtualMachineManagementServer getServer(String serverName) {
        return new VirtualMachineManagementServer(serverName);
    }

    public Object getTarget() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public void save() throws IOException {
    }

    public Collection<String> getServerNames() {
        return Collections2.transform(PluginImpl.getInstance().getServers(), Hypervisor::getHypervisorHost);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<VirtualMachineManagement> {
        public String getDisplayName() {
            return "virtual machine management";
        }
    }
}

