/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class VirtualMachineLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineLauncher.class.getName());
    private static final int MSEC_PER_SEC = 1000;
    private final ComputerLauncher delegate;
    private transient VirtualMachine virtualMachine;
    private final String hypervisorDescription;
    private final String virtualMachineName;
    private final String snapshotName;
    private final int waitTimeMs;
    private final int timesToRetryOnFailure;

    @DataBoundConstructor
    public VirtualMachineLauncher(ComputerLauncher delegate, String hypervisorDescription, String virtualMachineName, String snapshotName, int waitingTimeSecs, int timesToRetryOnFailure) {
        this.delegate = delegate;
        this.virtualMachineName = virtualMachineName;
        this.snapshotName = snapshotName;
        this.hypervisorDescription = hypervisorDescription;
        this.waitTimeMs = waitingTimeSecs * 1000;
        this.timesToRetryOnFailure = timesToRetryOnFailure;
        this.lookupVirtualMachineHandle();
    }

    private void lookupVirtualMachineHandle() {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            LOGGER.log(Level.FINE, "Grabbing hypervisor...");
            try {
                Hypervisor hypervisor = this.findOurHypervisorInstance();
                LOGGER.log(Level.FINE, "Hypervisor found, searching for a matching virtual machine for \"{0}\"...", this.virtualMachineName);
                for (VirtualMachine vm : hypervisor.getVirtualMachines()) {
                    if (!vm.getName().equals(this.virtualMachineName)) continue;
                    this.virtualMachine = vm;
                    break;
                }
            }
            catch (VirtException e) {
                LOGGER.log(Level.SEVERE, "no Hypervisor found, searching for a matching virtual machine for \"{0}\" {1}", new Object[]{this.virtualMachineName, e.getMessage()});
            }
        }
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public VirtualMachine getVirtualMachine() {
        this.lookupVirtualMachineHandle();
        return this.virtualMachine;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public Hypervisor findOurHypervisorInstance() throws VirtException {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            for (Cloud cloud : Jenkins.get().clouds) {
                if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(this.hypervisorDescription)) continue;
                return (Hypervisor)cloud;
            }
        }
        LOGGER.log(Level.SEVERE, "Could not find our libvirt cloud instance!");
        throw new VirtException("Could not find our libvirt cloud instance!");
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        block11: {
            taskListener.getLogger().println("Virtual machine \"" + this.virtualMachineName + "\" (agent title \"" + slaveComputer.getDisplayName() + "\") is to be started.");
            try {
                Map<String, IDomain> computers;
                IDomain domain;
                if (this.virtualMachine == null) {
                    taskListener.getLogger().println("No connection ready to the Hypervisor, connecting...");
                    this.lookupVirtualMachineHandle();
                    if (this.virtualMachine == null) {
                        throw new Exception("Virtual machine \"" + this.virtualMachineName + "\" (agent title \"" + slaveComputer.getDisplayName() + "\") not found on the specified hypervisor!");
                    }
                }
                if ((domain = (computers = this.virtualMachine.getHypervisor().getDomains()).get(this.virtualMachine.getName())) != null) {
                    if (domain.isNotBlockedAndNotRunning()) {
                        taskListener.getLogger().println("Starting, waiting for " + this.waitTimeMs + "ms to let it fully boot up...");
                        domain.create();
                        Thread.sleep(this.waitTimeMs);
                        int attempts = 0;
                        while (true) {
                            ++attempts;
                            taskListener.getLogger().println("Connecting agent client.");
                            try {
                                this.delegate.launch(slaveComputer, taskListener);
                            }
                            catch (IOException e) {
                                taskListener.getLogger().println("unexpectedly caught exception when delegating launch of agent: " + e.getMessage());
                            }
                            if (slaveComputer.isOnline()) break block11;
                            if (attempts >= this.timesToRetryOnFailure) {
                                taskListener.getLogger().println("Maximum retries reached. Failed to start agent client.");
                                break block11;
                            }
                            taskListener.getLogger().println("Not up yet, waiting for " + this.waitTimeMs + "ms more (" + attempts + "/" + this.timesToRetryOnFailure + " retries)...");
                            Thread.sleep(this.waitTimeMs);
                        }
                    }
                    taskListener.getLogger().println("Already running, no startup required.");
                    taskListener.getLogger().println("Connecting agent client.");
                    this.delegate.launch(slaveComputer, taskListener);
                    break block11;
                }
                throw new IOException("VM \"" + this.virtualMachine.getName() + "\" (agent title \"" + slaveComputer.getDisplayName() + "\") not found!");
            }
            catch (IOException e) {
                taskListener.fatalError(e.getMessage(), new Object[]{e});
                LogRecord rec = new LogRecord(Level.SEVERE, "Error while launching {0} on Hypervisor {1}.");
                rec.setParameters(new Object[]{this.virtualMachine.getName(), this.virtualMachine.getHypervisor().getHypervisorURI()});
                rec.setThrown(e);
                LOGGER.log(rec);
                throw e;
            }
            catch (Exception t) {
                taskListener.fatalError(t.getMessage(), new Object[]{t});
                LogRecord rec = new LogRecord(Level.SEVERE, "Error while launching {0} on Hypervisor {1}.");
                rec.setParameters(new Object[]{this.virtualMachine.getName(), this.virtualMachine.getHypervisor().getHypervisorURI()});
                rec.setThrown(t);
                LOGGER.log(rec);
            }
        }
    }

    public synchronized void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.afterDisconnect(slaveComputer, taskListener);
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

