/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlave;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import java.io.IOException;
import java.util.Map;

@Extension
public final class LibvirtRunListener
extends RunListener<Run<?, ?>> {
    private static final int RETRY_MAX = 5;
    private static final int RETRY_WAIT_MS = 500;

    public void onStarted(Run<?, ?> r, TaskListener listener) {
        super.onStarted(r, listener);
    }

    public void onFinalized(Run<?, ?> r) {
        VirtualMachineSlave slave;
        super.onFinalized(r);
        Executor executor = r.getExecutor();
        if (executor == null) {
            return;
        }
        Computer computer = executor.getOwner();
        Node node = computer.getNode();
        if (node instanceof VirtualMachineSlave && (slave = (VirtualMachineSlave)node).getRebootAfterRun()) {
            try {
                System.err.println("NukeSlaveListener about to disconnect. The next error about an agent disconnecting is normal");
                computer.getChannel().syncLocalIO();
                computer.getChannel().close();
                computer.disconnect(null);
                computer.waitUntilOffline();
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            VirtualMachineLauncher launcher = (VirtualMachineLauncher)slave.getLauncher();
            VirtualMachine virtualMachine = launcher.getVirtualMachine();
            for (int i = 0; i < 5; ++i) {
                try {
                    Map<String, IDomain> computers = virtualMachine.getHypervisor().getDomains();
                    IDomain domain = computers.get(virtualMachine.getName());
                    domain.create();
                    break;
                }
                catch (VirtException e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }
}

