/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib.libvirt;

import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.IDomainSnapshot;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.plugins.libvirt.lib.libvirt.LibVirtDomainSnapshotImpl;
import org.libvirt.Domain;
import org.libvirt.DomainInfo;
import org.libvirt.DomainSnapshot;
import org.libvirt.LibvirtException;

public class LibVirtDomainImpl
implements IDomain {
    private final Domain domain;

    public LibVirtDomainImpl(Domain domain) {
        this.domain = domain;
    }

    public String getName() throws VirtException {
        try {
            return this.domain.getName();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public String[] snapshotListNames() throws VirtException {
        try {
            return this.domain.snapshotListNames();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public int snapshotNum() throws VirtException {
        try {
            return this.domain.snapshotNum();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public IDomainSnapshot snapshotLookupByName(String snapshotName) throws VirtException {
        try {
            return new LibVirtDomainSnapshotImpl(this.domain.snapshotLookupByName(snapshotName));
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public void revertToSnapshot(IDomainSnapshot ds) throws VirtException {
        try {
            DomainSnapshot snapshot = ((LibVirtDomainSnapshotImpl)ds).getSnapshot();
            this.domain.revertToSnapshot(snapshot);
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public void shutdown() throws VirtException {
        try {
            this.domain.shutdown();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public boolean isRunningOrBlocked() throws VirtException {
        try {
            return this.domain.getInfo().state.equals((Object)DomainInfo.DomainState.VIR_DOMAIN_RUNNING) || this.domain.getInfo().state.equals((Object)DomainInfo.DomainState.VIR_DOMAIN_BLOCKED);
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public boolean isNotBlockedAndNotRunning() throws VirtException {
        try {
            return this.domain.getInfo().state != DomainInfo.DomainState.VIR_DOMAIN_BLOCKED && this.domain.getInfo().state != DomainInfo.DomainState.VIR_DOMAIN_RUNNING;
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public void create() throws VirtException {
        try {
            this.domain.create();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public void destroy() throws VirtException {
        try {
            this.domain.destroy();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }

    public void suspend() throws VirtException {
        try {
            this.domain.suspend();
        }
        catch (LibvirtException e) {
            throw new VirtException(e);
        }
    }
}

