/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt.lib.jlibvirt;

import com.nirima.libvirt.Domain;
import com.nirima.libvirt.DomainSnapshot;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.IDomainSnapshot;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.plugins.libvirt.lib.jlibvirt.JLibVirtDomainSnapshotImpl;

public class JLibVirtDomainImpl
implements IDomain {
    private final Domain domain;

    public JLibVirtDomainImpl(Domain domain) {
        this.domain = domain;
    }

    public String getName() throws VirtException {
        try {
            return this.domain.getName();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public String[] snapshotListNames() throws VirtException {
        try {
            return this.domain.snapshotListNames();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public int snapshotNum() throws VirtException {
        try {
            return this.domain.snapshotNum();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public IDomainSnapshot snapshotLookupByName(String snapshotName) throws VirtException {
        try {
            return new JLibVirtDomainSnapshotImpl(this.domain.snapshotLookupByName(snapshotName));
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public void revertToSnapshot(IDomainSnapshot ds) throws VirtException {
        try {
            DomainSnapshot snapshot = ((JLibVirtDomainSnapshotImpl)ds).getSnapshot();
            this.domain.revertToSnapshot(snapshot);
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public void shutdown() throws VirtException {
        try {
            this.domain.shutdown();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public boolean isRunningOrBlocked() throws VirtException {
        try {
            Domain.DomainState domainState = this.domain.getState();
            return domainState.equals((Object)Domain.DomainState.RUNNING) || domainState.equals((Object)Domain.DomainState.BLOCKED);
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public boolean isNotBlockedAndNotRunning() throws VirtException {
        try {
            Domain.DomainState domainState = this.domain.getState();
            return domainState != Domain.DomainState.BLOCKED && domainState != Domain.DomainState.RUNNING;
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public void create() throws VirtException {
        try {
            this.domain.create();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public void destroy() throws VirtException {
        try {
            this.domain.destroy();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }

    public void suspend() throws VirtException {
        try {
            this.domain.suspend();
        }
        catch (Exception e) {
            throw new VirtException(e);
        }
    }
}

