/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlaveComputer;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineSlave
extends Slave {
    private String hypervisorDescription;
    private String snapshotName;
    private String virtualMachineName;
    private int startupWaitingPeriodSeconds;
    private String shutdownMethod;
    private boolean rebootAfterRun;
    private int startupTimesToRetryOnFailure;
    private String beforeJobSnapshotName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VirtualMachineSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, VirtualMachineLauncher launcher, ComputerLauncher delegateLauncher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, String hypervisorDescription, String virtualMachineName, String snapshotName, int startupWaitingPeriodSeconds, String shutdownMethod, boolean rebootAfterRun, int startupTimesToRetryOnFailure, String beforeJobSnapshotName) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, Util.tryParseNumber((String)numExecutors, (Number)1).intValue(), mode, labelString, (ComputerLauncher)(launcher == null ? new VirtualMachineLauncher(delegateLauncher, hypervisorDescription, virtualMachineName, snapshotName, startupWaitingPeriodSeconds, startupTimesToRetryOnFailure) : launcher), retentionStrategy, nodeProperties);
        this.hypervisorDescription = hypervisorDescription;
        this.virtualMachineName = virtualMachineName;
        this.snapshotName = snapshotName;
        this.startupWaitingPeriodSeconds = startupWaitingPeriodSeconds;
        this.shutdownMethod = shutdownMethod;
        this.rebootAfterRun = rebootAfterRun;
        this.startupTimesToRetryOnFailure = startupTimesToRetryOnFailure;
        this.beforeJobSnapshotName = beforeJobSnapshotName;
    }

    public String getHypervisorDescription() {
        return this.hypervisorDescription;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public int getStartupWaitingPeriodSeconds() {
        return this.startupWaitingPeriodSeconds;
    }

    public String getShutdownMethod() {
        return this.shutdownMethod;
    }

    public boolean getRebootAfterRun() {
        return this.rebootAfterRun;
    }

    public int getStartupTimesToRetryOnFailure() {
        return this.startupTimesToRetryOnFailure;
    }

    public String getBeforeJobSnapshotName() {
        return this.beforeJobSnapshotName;
    }

    public ComputerLauncher getDelegateLauncher() {
        return ((VirtualMachineLauncher)this.getLauncher()).getDelegate();
    }

    public Computer createComputer() {
        return new VirtualMachineSlaveComputer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        private String hypervisorDescription;
        private String virtualMachineName;
        private String snapshotName;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Slave virtual computer running on a virtualization platform (via libvirt)";
        }

        public boolean isInstantiable() {
            return true;
        }

        public List<VirtualMachine> getDefinedVirtualMachines(String hypervisorDescription) {
            ArrayList<VirtualMachine> virtualMachinesList = new ArrayList<VirtualMachine>();
            Hypervisor hypervisor = this.getHypervisorByDescription(hypervisorDescription);
            if (hypervisor != null) {
                virtualMachinesList.addAll(hypervisor.getVirtualMachines());
            }
            Collections.sort(virtualMachinesList);
            return virtualMachinesList;
        }

        public String[] getDefinedSnapshots(String hypervisorDescription, String virtualMachineName) {
            Hypervisor hypervisor = this.getHypervisorByDescription(hypervisorDescription);
            if (hypervisor != null) {
                String[] snapS = hypervisor.getSnapshots(virtualMachineName);
                return snapS;
            }
            return new String[0];
        }

        public ListBoxModel doFillHypervisorDescriptionItems() {
            ListBoxModel items = new ListBoxModel();
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof Hypervisor)) continue;
                items.add(((Hypervisor)cloud).getHypervisorURI(), ((Hypervisor)cloud).getHypervisorDescription());
            }
            return items;
        }

        public String getHypervisorDescription() {
            return this.hypervisorDescription;
        }

        public String getVirtualMachineName() {
            return this.virtualMachineName;
        }

        public String getSnapshotName() {
            return this.snapshotName;
        }

        private Hypervisor getHypervisorByDescription(String hypervisorDescription) {
            if (hypervisorDescription != null && !hypervisorDescription.equals("")) {
                for (Cloud cloud : Hudson.getInstance().clouds) {
                    if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(hypervisorDescription)) continue;
                    return (Hypervisor)cloud;
                }
            }
            return null;
        }
    }

    @Extension
    public static class VirtualMachineComputerListener
    extends ComputerListener {
        public void preLaunch(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
            if (!(c.getNode() instanceof VirtualMachineSlave)) {
                return;
            }
            VirtualMachineLauncher vmL = (VirtualMachineLauncher)((SlaveComputer)c).getLauncher();
            Hypervisor vmC = vmL.findOurHypervisorInstance();
            if (!vmC.markVMOnline(c.getDisplayName(), vmL.getVirtualMachineName()).booleanValue()) {
                throw new AbortException("Capacity threshold  (" + vmC.getMaxOnlineSlaves() + ") reached at hypervisor \"" + vmC.getHypervisorDescription() + "\", slave commissioning delayed.");
            }
        }
    }
}

