/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.libvirt.Hypervisor;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMachineLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(VirtualMachineLauncher.class.getName());
    private ComputerLauncher delegate;
    private transient VirtualMachine virtualMachine;
    private String hypervisorDescription;
    private String virtualMachineName;
    private String snapshotName;
    private final int WAIT_TIME_MS;
    private final int timesToRetryOnFailure;

    @DataBoundConstructor
    public VirtualMachineLauncher(ComputerLauncher delegate, String hypervisorDescription, String virtualMachineName, String snapshotName, int waitingTimeSecs, int timesToRetryOnFailure) {
        this.delegate = delegate;
        this.virtualMachineName = virtualMachineName;
        this.snapshotName = snapshotName;
        this.hypervisorDescription = hypervisorDescription;
        this.WAIT_TIME_MS = waitingTimeSecs * 1000;
        this.timesToRetryOnFailure = timesToRetryOnFailure;
        this.lookupVirtualMachineHandle();
    }

    private void lookupVirtualMachineHandle() {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            LOGGER.log(Level.FINE, "Grabbing hypervisor...");
            Hypervisor hypervisor = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(this.hypervisorDescription)) continue;
                hypervisor = (Hypervisor)cloud;
                break;
            }
            LOGGER.log(Level.FINE, "Hypervisor found, searching for a matching virtual machine for \"" + this.virtualMachineName + "\"...");
            for (VirtualMachine vm : hypervisor.getVirtualMachines()) {
                if (!vm.getName().equals(this.virtualMachineName)) continue;
                this.virtualMachine = vm;
                break;
            }
        }
    }

    public ComputerLauncher getDelegate() {
        return this.delegate;
    }

    public VirtualMachine getVirtualMachine() {
        this.lookupVirtualMachineHandle();
        return this.virtualMachine;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public Hypervisor findOurHypervisorInstance() throws RuntimeException {
        if (this.hypervisorDescription != null && this.virtualMachineName != null) {
            Hypervisor hypervisor = null;
            for (Cloud cloud : Hudson.getInstance().clouds) {
                if (!(cloud instanceof Hypervisor) || !((Hypervisor)cloud).getHypervisorDescription().equals(this.hypervisorDescription)) continue;
                hypervisor = (Hypervisor)cloud;
                return hypervisor;
            }
        }
        LOGGER.log(Level.SEVERE, "Could not find our libvirt cloud instance!");
        throw new RuntimeException("Could not find our libvirt cloud instance!");
    }

    public void launch(SlaveComputer slaveComputer, TaskListener taskListener) throws IOException, InterruptedException {
        block11: {
            taskListener.getLogger().println("Virtual machine \"" + this.virtualMachineName + "\" (slave title \"" + slaveComputer.getDisplayName() + "\") is to be started.");
            try {
                Map<String, IDomain> computers;
                IDomain domain;
                if (this.virtualMachine == null) {
                    taskListener.getLogger().println("No connection ready to the Hypervisor, connecting...");
                    this.lookupVirtualMachineHandle();
                    if (this.virtualMachine == null) {
                        throw new Exception("Virtual machine \"" + this.virtualMachineName + "\" (slave title \"" + slaveComputer.getDisplayName() + "\") not found on the specified hypervisor!");
                    }
                }
                if ((domain = (computers = this.virtualMachine.getHypervisor().getDomains()).get(this.virtualMachine.getName())) != null) {
                    if (domain.isNotBlockedAndNotRunning()) {
                        taskListener.getLogger().println("Starting, waiting for " + this.WAIT_TIME_MS + "ms to let it fully boot up...");
                        domain.create();
                        Thread.sleep(this.WAIT_TIME_MS);
                        int attempts = 0;
                        while (true) {
                            ++attempts;
                            taskListener.getLogger().println("Connecting slave client.");
                            try {
                                this.delegate.launch(slaveComputer, taskListener);
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            if (slaveComputer.isOnline()) break block11;
                            if (attempts >= this.timesToRetryOnFailure) {
                                taskListener.getLogger().println("Maximum retries reached. Failed to start slave client.");
                                break block11;
                            }
                            taskListener.getLogger().println("Not up yet, waiting for " + this.WAIT_TIME_MS + "ms more (" + attempts + "/" + this.timesToRetryOnFailure + " retries)...");
                            Thread.sleep(this.WAIT_TIME_MS);
                        }
                    }
                    taskListener.getLogger().println("Already running, no startup required.");
                    taskListener.getLogger().println("Connecting slave client.");
                    this.delegate.launch(slaveComputer, taskListener);
                    break block11;
                }
                throw new IOException("VM \"" + this.virtualMachine.getName() + "\" (slave title \"" + slaveComputer.getDisplayName() + "\") not found!");
            }
            catch (IOException e) {
                taskListener.fatalError(e.getMessage(), new Object[]{e});
                LogRecord rec = new LogRecord(Level.SEVERE, "Error while launching {0} on Hypervisor {1}.");
                rec.setParameters(new Object[]{this.virtualMachine.getName(), this.virtualMachine.getHypervisor().getHypervisorURI()});
                rec.setThrown(e);
                LOGGER.log(rec);
                throw e;
            }
            catch (Throwable t) {
                taskListener.fatalError(t.getMessage(), new Object[]{t});
                LogRecord rec = new LogRecord(Level.SEVERE, "Error while launching {0} on Hypervisor {1}.");
                rec.setParameters(new Object[]{this.virtualMachine.getName(), this.virtualMachine.getHypervisor().getHypervisorURI()});
                rec.setThrown(t);
                LOGGER.log(rec);
            }
        }
    }

    public synchronized void afterDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.afterDisconnect(slaveComputer, taskListener);
    }

    public void beforeDisconnect(SlaveComputer slaveComputer, TaskListener taskListener) {
        this.delegate.beforeDisconnect(slaveComputer, taskListener);
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

