/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.VirtualMachineLauncher;
import hudson.plugins.libvirt.VirtualMachineSlave;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class LibvirtRunListener
extends RunListener<Run> {
    public void onStarted(Run r, TaskListener listener) {
        super.onStarted(r, listener);
    }

    public void onFinalized(Run r) {
        VirtualMachineSlave slave;
        super.onFinalized(r);
        Computer computer = r.getExecutor().getOwner();
        Node node = computer.getNode();
        if (node instanceof VirtualMachineSlave && (slave = (VirtualMachineSlave)node).getRebootAfterRun()) {
            try {
                System.err.println("NukeSlaveListener about to disconnect. the next error bitching about a slave disconnecting is normal");
                computer.getChannel().syncLocalIO();
                computer.getChannel().close();
                computer.disconnect(null);
                computer.waitUntilOffline();
            }
            catch (Exception e) {
                // empty catch block
            }
            VirtualMachineLauncher launcher = (VirtualMachineLauncher)slave.getLauncher();
            VirtualMachine virtualMachine = launcher.getVirtualMachine();
            for (int i = 0; i < 5; ++i) {
                try {
                    Map<String, IDomain> computers = virtualMachine.getHypervisor().getDomains();
                    IDomain domain = computers.get(virtualMachine.getName());
                    domain.create();
                    break;
                }
                catch (VirtException e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }
}

