/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.libvirt;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.google.common.base.Strings;
import com.trilead.ssh2.Connection;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.plugins.libvirt.VirtualMachine;
import hudson.plugins.libvirt.lib.ConnectionBuilder;
import hudson.plugins.libvirt.lib.IConnect;
import hudson.plugins.libvirt.lib.IDomain;
import hudson.plugins.libvirt.lib.VirtException;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hypervisor
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(Hypervisor.class.getName());
    private final String hypervisorType;
    private final String hypervisorHost;
    private final String hypervisorSystemUrl;
    private final int hypervisorSshPort;
    private final String username;
    private final int maxOnlineSlaves;
    private transient int currentOnlineSlaveCount = 0;
    private transient Hashtable<String, String> currentOnline;
    private transient IConnect connection;
    private final boolean useNativeJavaConnection;
    private final String credentialsId;

    @DataBoundConstructor
    public Hypervisor(String hypervisorType, String hypervisorHost, int hypervisorSshPort, String hypervisorSystemUrl, String username, int maxOnlineSlaves, boolean useNativeJavaConnection, String credentialsId) {
        super("Hypervisor(libvirt)");
        this.hypervisorType = hypervisorType;
        this.hypervisorHost = hypervisorHost;
        this.hypervisorSystemUrl = hypervisorSystemUrl != null ? hypervisorSystemUrl : "system";
        this.hypervisorSshPort = hypervisorSshPort <= 0 ? 22 : hypervisorSshPort;
        this.username = username;
        this.maxOnlineSlaves = maxOnlineSlaves;
        this.useNativeJavaConnection = useNativeJavaConnection;
        this.credentialsId = credentialsId;
    }

    protected void ensureLists() {
        if (this.currentOnline == null) {
            this.currentOnline = new Hashtable();
        }
    }

    private ConnectionBuilder createBuilder() {
        return ConnectionBuilder.newBuilder().hypervisorType(this.hypervisorType).userName(this.username).withCredentials(Hypervisor.lookupSystemCredentials(this.credentialsId)).hypervisorHost(this.hypervisorHost).hypervisorPort(this.hypervisorSshPort).hypervisorSysUrl(this.hypervisorSystemUrl).useNativeJava(this.useNativeJavaConnection);
    }

    private synchronized IConnect getOrCreateConnection() throws VirtException {
        if (this.connection == null || !this.connection.isConnected()) {
            ConnectionBuilder builder = this.createBuilder();
            LOGGER.log(Level.INFO, "Trying to establish a connection to hypervisor URI: {0} as {1}/******", new Object[]{builder.constructHypervisorURI(), this.username});
            try {
                this.connection = builder.build();
                LOGGER.log(Level.INFO, "Established connection to hypervisor URI: {0} as {1}/******", new Object[]{builder.constructHypervisorURI(), this.username});
            }
            catch (VirtException e) {
                LogRecord rec = new LogRecord(Level.SEVERE, "Failed to establish connection to hypervisor URI: {0} as {1}/******");
                rec.setThrown(e);
                rec.setParameters(new Object[]{builder.constructHypervisorURI(), this.username});
                LOGGER.log(rec);
            }
        } else {
            try {
                this.connection.getVersion();
            }
            catch (VirtException lve) {
                ConnectionBuilder builder = this.createBuilder();
                LogRecord rec = new LogRecord(Level.WARNING, "Connection appears to be broken, trying to reconnect: {0} as {1}/******");
                rec.setParameters(new Object[]{builder.constructHypervisorURI(), this.username});
                LOGGER.log(rec);
                try {
                    this.connection = builder.build();
                }
                catch (VirtException lve2) {
                    rec = new LogRecord(Level.SEVERE, "Failed to re-establish connection to hypervisor URI: {0} as {1}/******");
                    rec.setThrown(lve2);
                    rec.setParameters(new Object[]{builder.constructHypervisorURI(), this.username});
                    LOGGER.log(rec);
                }
            }
        }
        return this.connection;
    }

    public String getHypervisorHost() {
        return this.hypervisorHost;
    }

    public int getHypervisorSshPort() {
        return this.hypervisorSshPort;
    }

    public String getHypervisorType() {
        return this.hypervisorType;
    }

    public String getHypervisorSystemUrl() {
        return this.hypervisorSystemUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isUseNativeJavaConnection() {
        return this.useNativeJavaConnection;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public int getMaxOnlineSlaves() {
        return this.maxOnlineSlaves;
    }

    public synchronized int getCurrentOnlineSlaveCount() {
        return this.currentOnlineSlaveCount;
    }

    public String getHypervisorDescription() {
        return this.getHypervisorType() + " - " + this.getHypervisorHost();
    }

    public synchronized Map<String, IDomain> getDomains() throws VirtException {
        HashMap<String, IDomain> domains = new HashMap<String, IDomain>();
        IConnect con = this.getOrCreateConnection();
        LogRecord info = new LogRecord(Level.FINE, "Getting hypervisor domains.");
        LOGGER.log(info);
        if (con != null) {
            LogRecord rec;
            IDomain domain;
            for (String c : con.listDefinedDomains()) {
                if (c == null || c.equals("")) continue;
                domain = null;
                try {
                    domain = con.domainLookupByName(c);
                    domains.put(domain.getName(), domain);
                }
                catch (Exception e) {
                    rec = new LogRecord(Level.WARNING, "Error retrieving information for domain with name: {0}.");
                    rec.setParameters(new Object[]{c});
                    rec.setThrown(e);
                    LOGGER.log(rec);
                }
            }
            for (int c : con.listDomains()) {
                domain = null;
                try {
                    domain = con.domainLookupByID(c);
                    domains.put(domain.getName(), domain);
                }
                catch (Exception e) {
                    rec = new LogRecord(Level.WARNING, "Error retrieving information for domain with id: {0}.");
                    rec.setParameters(new Object[]{c});
                    rec.setThrown(e);
                    LOGGER.log(rec);
                }
            }
        } else {
            LogRecord logRecord = new LogRecord(Level.SEVERE, "Cannot connect to Hypervisor {0} as {1}/******");
            logRecord.setParameters(new Object[]{this.hypervisorHost, this.username});
            LOGGER.log(logRecord);
        }
        return domains;
    }

    public synchronized List<VirtualMachine> getVirtualMachines() {
        ArrayList<VirtualMachine> vmList = new ArrayList<VirtualMachine>();
        try {
            Map<String, IDomain> domains = this.getDomains();
            for (String domainName : domains.keySet()) {
                vmList.add(new VirtualMachine(this, domainName));
            }
        }
        catch (Exception e) {
            LogRecord rec = new LogRecord(Level.SEVERE, "Cannot connect to datacenter {0} as {1}/******");
            rec.setThrown(e);
            rec.setParameters(new Object[]{this.hypervisorHost, this.username});
            LOGGER.log(rec);
        }
        return vmList;
    }

    public synchronized String[] getSnapshots(String virtualMachineName) {
        try {
            for (IDomain domain : this.getDomains().values()) {
                if (!domain.getName().equals(virtualMachineName)) continue;
                LogRecord rec = new LogRecord(Level.FINE, "Fetching snapshots for " + virtualMachineName + ": " + domain.snapshotNum());
                LOGGER.log(rec);
                return domain.snapshotListNames();
            }
        }
        catch (VirtException lve) {
            LogRecord rec = new LogRecord(Level.SEVERE, "Failed to fetch snapshot ids for VM {0} at datacenter {1} as {2}/******");
            rec.setThrown(lve);
            rec.setParameters(new Object[]{virtualMachineName, this.hypervisorHost, this.username});
            LOGGER.log(rec);
        }
        return new String[0];
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int i) {
        return Collections.emptySet();
    }

    public boolean canProvision(Label label) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Hypervisor");
        sb.append("{hypervisorUri='").append(this.hypervisorHost).append('\'');
        sb.append(", username='").append(this.username).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public synchronized Boolean canMarkVMOnline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.maxOnlineSlaves > 0 && this.currentOnline.size() == this.maxOnlineSlaves) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsValue(vmName)) {
            return Boolean.FALSE;
        }
        if (this.currentOnline.containsKey(slaveName)) {
            return Boolean.FALSE;
        }
        if ("".equals(vmName) || "".equals(slaveName)) {
            LogRecord rec = new LogRecord(Level.WARNING, "Slave '" + slaveName + "' (using VM '" + vmName + "') appears to be misconfigured.");
            LOGGER.log(rec);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public synchronized Boolean markVMOnline(String slaveName, String vmName) {
        this.ensureLists();
        if (this.currentOnline.containsKey(slaveName) && this.currentOnline.get(slaveName).equals(vmName)) {
            return Boolean.TRUE;
        }
        if (!this.canMarkVMOnline(slaveName, vmName).booleanValue()) {
            return Boolean.FALSE;
        }
        this.currentOnline.put(slaveName, vmName);
        ++this.currentOnlineSlaveCount;
        return Boolean.TRUE;
    }

    public synchronized void markVMOffline(String slaveName, String vmName) throws VirtException {
        this.ensureLists();
        if (this.currentOnline.remove(slaveName) != null) {
            --this.currentOnlineSlaveCount;
        }
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            this.connection.close();
        }
        super.finalize();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId) {
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return null;
        }
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new SchemeRequirement("ssh")}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public String getHypervisorURI() {
        return this.createBuilder().constructHypervisorURI();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public final ConcurrentMap<String, Hypervisor> hypervisors = new ConcurrentHashMap<String, Hypervisor>();
        private String hypervisorType;
        private String hypervisorHost;
        private String hypervisorSystemUrl;
        private int hypervisorSshPort;
        private String username;

        public String getDisplayName() {
            return "Hypervisor (via libvirt)";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.hypervisorType = o.getString("hypervisorType");
            this.hypervisorHost = o.getString("hypervisorHost");
            this.hypervisorSystemUrl = o.getString("hypervisorSystemUrl");
            this.hypervisorSshPort = o.getInt("hypervisorSshPort");
            this.username = o.getString("username");
            this.save();
            return super.configure(req, o);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            return new SSHUserListBoxModel().withMatching(SSHAuthenticator.matcher(Connection.class), (Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new SchemeRequirement("ssh")}));
        }

        public FormValidation doTestConnection(@QueryParameter String hypervisorType, @QueryParameter String hypervisorHost, @QueryParameter String hypervisorSshPort, @QueryParameter String username, @QueryParameter String hypervisorSystemUrl, @QueryParameter boolean useNativeJavaConnection, @QueryParameter String credentialsId) throws Exception, ServletException {
            try {
                if (hypervisorHost == null) {
                    return FormValidation.error((String)"Hypervisor Host is not specified!");
                }
                if (hypervisorType == null) {
                    return FormValidation.error((String)"Hypervisor type is not specified!");
                }
                if (username == null) {
                    return FormValidation.error((String)"Username is not specified!");
                }
                ConnectionBuilder builder = ConnectionBuilder.newBuilder().hypervisorType(hypervisorType).userName(username).withCredentials(Hypervisor.lookupSystemCredentials(credentialsId)).hypervisorHost(hypervisorHost).hypervisorPort(Integer.parseInt(hypervisorSshPort)).hypervisorSysUrl(hypervisorSystemUrl).useNativeJava(useNativeJavaConnection);
                String hypervisorUri = builder.constructHypervisorURI();
                LogRecord rec = new LogRecord(Level.FINE, "Testing connection to hypervisor: {0}");
                rec.setParameters(new Object[]{hypervisorUri});
                LOGGER.log(rec);
                IConnect hypervisorConnection = builder.build();
                long version = hypervisorConnection.getVersion();
                hypervisorConnection.close();
                return FormValidation.ok((String)("OK: " + hypervisorUri + ", version=" + version));
            }
            catch (VirtException e) {
                LogRecord rec = new LogRecord(Level.WARNING, "Failed to check hypervisor connection to {0} as {1}/******");
                rec.setThrown(e);
                rec.setParameters(new Object[]{hypervisorHost, username});
                LOGGER.log(rec);
                return FormValidation.error((String)e.getMessage());
            }
            catch (UnsatisfiedLinkError e) {
                LogRecord rec = new LogRecord(Level.WARNING, "Failed to connect to hypervisor. Check libvirt installation on jenkins machine!");
                rec.setThrown(e);
                rec.setParameters(new Object[]{hypervisorHost, username});
                LOGGER.log(rec);
                return FormValidation.error((String)e.getMessage());
            }
            catch (Exception e) {
                LogRecord rec = new LogRecord(Level.WARNING, "Failed to connect to hypervisor. Check libvirt installation on jenkins machine!");
                rec.setThrown(e);
                rec.setParameters(new Object[]{hypervisorHost, username});
                LOGGER.log(rec);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public String getHypervisorHost() {
            return this.hypervisorHost;
        }

        public int getHypervisorSshPort() {
            return this.hypervisorSshPort;
        }

        public String getHypervisorSystemUrl() {
            return this.hypervisorSystemUrl;
        }

        public String getHypervisorType() {
            return this.hypervisorType;
        }

        public String getUsername() {
            return this.username;
        }

        public List<String> getHypervisorTypes() {
            ArrayList<String> types = new ArrayList<String>();
            types.add("QEMU");
            types.add("XEN");
            types.add("LXC");
            types.add("BHYVE");
            return types;
        }
    }
}

