/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.LDAPSecurityRealm;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import jenkins.model.Jenkins;
import jenkins.security.plugins.ldap.BindAuthenticator2;
import jenkins.security.plugins.ldap.FromGroupSearchLDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPExtendedTemplate;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.Messages;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LDAPConfiguration
extends AbstractDescribableImpl<LDAPConfiguration> {
    private static final Logger LOGGER = LDAPSecurityRealm.LOGGER;
    private final String server;
    private final String rootDN;
    private final boolean inhibitInferRootDN;
    private String userSearchBase;
    private String userSearch;
    private String groupSearchBase;
    private String groupSearchFilter;
    private LDAPGroupMembershipStrategy groupMembershipStrategy;
    private final String managerDN;
    private final Secret managerPasswordSecret;
    private String displayNameAttributeName;
    private String mailAddressAttributeName;
    private boolean ignoreIfUnavailable;
    private Map<String, String> extraEnvVars;
    private transient LDAPExtendedTemplate ldapTemplate;
    private transient String id;

    @DataBoundConstructor
    public LDAPConfiguration(@NonNull String server, String rootDN, boolean inhibitInferRootDN, String managerDN, Secret managerPasswordSecret) {
        this.server = server.trim();
        this.managerDN = Util.fixEmpty((String)managerDN);
        this.managerPasswordSecret = managerPasswordSecret;
        this.inhibitInferRootDN = inhibitInferRootDN;
        if (!inhibitInferRootDN && Util.fixEmptyAndTrim((String)rootDN) == null) {
            rootDN = Util.fixNull((String)this.inferRootDN(server));
        }
        this.rootDN = rootDN;
        this.displayNameAttributeName = "displayname";
        this.mailAddressAttributeName = "mail";
        this.userSearchBase = "";
        this.userSearch = "uid={0}";
        this.groupMembershipStrategy = new FromGroupSearchLDAPGroupMembershipStrategy("");
        this.groupSearchBase = "";
    }

    public String getServer() {
        return this.server;
    }

    public String getServerUrl() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : Util.fixNull((String)this.server).split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(LDAPConfiguration.addPrefix(s));
        }
        return buf.toString();
    }

    public String getRootDN() {
        return this.rootDN;
    }

    public String getLDAPURL() {
        return LDAPSecurityRealm.toProviderUrl(this.getServerUrl(), Util.fixNull((String)this.rootDN));
    }

    public boolean isInhibitInferRootDN() {
        return this.inhibitInferRootDN;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    @DataBoundSetter
    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = Util.fixNull((String)userSearchBase).trim();
    }

    public String getUserSearch() {
        return this.userSearch;
    }

    @DataBoundSetter
    public void setUserSearch(String userSearch) {
        this.userSearch = (userSearch = Util.fixEmptyAndTrim((String)userSearch)) != null ? userSearch : "uid={0}";
    }

    public String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    @DataBoundSetter
    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = Util.fixEmptyAndTrim((String)groupSearchBase);
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    @DataBoundSetter
    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = Util.fixEmptyAndTrim((String)groupSearchFilter);
    }

    public LDAPGroupMembershipStrategy getGroupMembershipStrategy() {
        return this.groupMembershipStrategy;
    }

    @DataBoundSetter
    public void setGroupMembershipStrategy(LDAPGroupMembershipStrategy groupMembershipStrategy) {
        this.groupMembershipStrategy = groupMembershipStrategy == null ? new FromGroupSearchLDAPGroupMembershipStrategy("") : groupMembershipStrategy;
    }

    public String getManagerDN() {
        return this.managerDN;
    }

    public String getManagerPassword() {
        return Secret.toString((Secret)this.managerPasswordSecret);
    }

    public Secret getManagerPasswordSecret() {
        return this.managerPasswordSecret;
    }

    public String getDisplayNameAttributeName() {
        return StringUtils.defaultString((String)this.displayNameAttributeName, (String)"displayname");
    }

    @DataBoundSetter
    public void setDisplayNameAttributeName(String displayNameAttributeName) {
        this.displayNameAttributeName = displayNameAttributeName;
    }

    public String getMailAddressAttributeName() {
        return StringUtils.defaultString((String)this.mailAddressAttributeName, (String)"mail");
    }

    @DataBoundSetter
    public void setMailAddressAttributeName(String mailAddressAttributeName) {
        this.mailAddressAttributeName = mailAddressAttributeName;
    }

    public boolean isIgnoreIfUnavailable() {
        return this.ignoreIfUnavailable;
    }

    @DataBoundSetter
    public void setIgnoreIfUnavailable(boolean ignoreIfUnavailable) {
        this.ignoreIfUnavailable = ignoreIfUnavailable;
    }

    public Map<String, String> getExtraEnvVars() {
        return this.extraEnvVars == null || this.extraEnvVars.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.extraEnvVars);
    }

    @Restricted(value={NoExternalUse.class})
    public void setExtraEnvVars(Map<String, String> extraEnvVars) {
        this.extraEnvVars = extraEnvVars;
    }

    public LDAPSecurityRealm.EnvironmentProperty[] getEnvironmentProperties() {
        if (this.extraEnvVars == null || this.extraEnvVars.isEmpty()) {
            return new LDAPSecurityRealm.EnvironmentProperty[0];
        }
        LDAPSecurityRealm.EnvironmentProperty[] result = new LDAPSecurityRealm.EnvironmentProperty[this.extraEnvVars.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.extraEnvVars.entrySet()) {
            result[i++] = new LDAPSecurityRealm.EnvironmentProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @DataBoundSetter
    public void setEnvironmentProperties(LDAPSecurityRealm.EnvironmentProperty[] environmentProperties) {
        this.extraEnvVars = environmentProperties == null || environmentProperties.length == 0 ? null : LDAPSecurityRealm.EnvironmentProperty.toMap(Arrays.asList(environmentProperties));
    }

    public String getId() {
        if (StringUtils.isEmpty((String)this.id)) {
            this.id = this.generateId();
        }
        return this.id;
    }

    public boolean isConfiguration(String id) {
        return this.getId().equals(id);
    }

    private String inferRootDN(String server) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.managerDN != null) {
                props.put("java.naming.security.principal", this.managerDN);
                props.put("java.naming.security.credentials", this.getManagerPassword());
            }
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.provider.url", LDAPSecurityRealm.toProviderUrl(this.getServerUrl(), ""));
            InitialDirContext ctx = new InitialDirContext(props);
            Attributes atts = ctx.getAttributes("");
            Attribute a = atts.get("defaultNamingContext");
            if (a != null && a.get() != null) {
                return a.get().toString();
            }
            a = atts.get("namingcontexts");
            if (a == null) {
                LOGGER.warning("namingcontexts attribute not found in root DSE of " + server);
                return null;
            }
            return a.get().toString();
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to LDAP to infer Root DN for " + server, e);
            return null;
        }
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    private String generateId() {
        return LDAPConfiguration.generateId(this.server, this.rootDN, this.userSearchBase, this.userSearch);
    }

    @Restricted(value={NoExternalUse.class})
    static String generateId(String serverUrl, String rootDN, String userSearchBase, String userSearch) {
        MessageDigest digest = DigestUtils.getMd5Digest();
        digest.update(LDAPConfiguration.normalizeServer(serverUrl).getBytes(Charsets.UTF_8));
        String userSearchBaseNormalized = LDAPConfiguration.normalizeUserSearchBase(rootDN, userSearchBase);
        if (StringUtils.isNotBlank((String)userSearchBaseNormalized)) {
            digest.update(userSearchBaseNormalized.getBytes(Charsets.UTF_8));
        } else {
            digest.update(new byte[]{0});
        }
        if (StringUtils.isNotBlank((String)userSearch)) {
            digest.update(userSearch.getBytes(Charsets.UTF_8));
        } else {
            digest.update("uid={0}".getBytes(Charsets.UTF_8));
        }
        return Base64.encodeBase64String((byte[])digest.digest());
    }

    private static String normalizeUserSearchBase(String rootDN, String userSearchBase) {
        if (StringUtils.isBlank((String)rootDN) && StringUtils.isBlank((String)userSearchBase)) {
            return "";
        }
        if (StringUtils.isBlank((String)rootDN)) {
            return userSearchBase;
        }
        if (StringUtils.isBlank((String)userSearchBase)) {
            return rootDN;
        }
        rootDN = rootDN.trim();
        userSearchBase = userSearchBase.trim();
        return userSearchBase + "," + rootDN;
    }

    @Restricted(value={NoExternalUse.class})
    static String normalizeServer(String server) {
        String[] urls = Util.fixNull((String)server).split("\\s+");
        ArrayList<String> normalised = new ArrayList<String>(urls.length);
        for (String url : urls) {
            if (StringUtils.isBlank((String)url)) continue;
            url = LDAPConfiguration.addPrefix(url);
            try {
                URI uri = new URI(url);
                if (uri.getPort() < 0) {
                    uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 389, uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                normalised.add(uri.toString());
            }
            catch (URISyntaxException e) {
                LOGGER.warning("Unable to parse " + url + " into an URI");
            }
        }
        Collections.sort(normalised);
        return StringUtils.join(normalised, (char)' ');
    }

    @Restricted(value={NoExternalUse.class})
    public ApplicationContext createApplicationContext(LDAPSecurityRealm realm) {
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.getLDAPURL());
        if (this.getManagerDN() != null) {
            contextSource.setUserDn(this.getManagerDN());
            contextSource.setPassword(this.getManagerPassword());
        }
        contextSource.setReferral("follow");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("com.sun.jndi.ldap.connect.timeout", "30000");
        vars.put("com.sun.jndi.ldap.read.timeout", "60000");
        vars.putAll(this.getExtraEnvVars());
        contextSource.setBaseEnvironmentProperties(vars);
        contextSource.afterPropertiesSet();
        FilterBasedLdapUserSearch ldapUserSearch = new FilterBasedLdapUserSearch(this.getUserSearchBase(), this.getUserSearch(), (BaseLdapPathContextSource)contextSource);
        ldapUserSearch.setSearchSubtree(true);
        ldapUserSearch.setReturningAttributes(new String[]{"*", "+"});
        BindAuthenticator2 bindAuthenticator = new BindAuthenticator2((BaseLdapPathContextSource)contextSource);
        bindAuthenticator.setUserSearch((LdapUserSearch)ldapUserSearch);
        LDAPSecurityRealm.AuthoritiesPopulatorImpl ldapAuthoritiesPopulator = new LDAPSecurityRealm.AuthoritiesPopulatorImpl((ContextSource)contextSource, this.getGroupSearchBase());
        ldapAuthoritiesPopulator.setSearchSubtree(true);
        ldapAuthoritiesPopulator.setGroupSearchFilter("(| (member={0}) (uniqueMember={0}) (memberUid={1}))");
        if (realm.isDisableRolePrefixing()) {
            ldapAuthoritiesPopulator.setRolePrefix("");
            ldapAuthoritiesPopulator.setConvertToUpperCase(false);
        }
        ArrayList<LDAPSecurityRealm.LdapAuthenticationProviderImpl> providers = new ArrayList<LDAPSecurityRealm.LdapAuthenticationProviderImpl>();
        providers.add(new LDAPSecurityRealm.LdapAuthenticationProviderImpl((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)ldapAuthoritiesPopulator, this.getGroupMembershipStrategy()));
        providers.add((LDAPSecurityRealm.LdapAuthenticationProviderImpl)new RememberMeAuthenticationProvider(Jenkins.get().getSecretKey()));
        providers.add((LDAPSecurityRealm.LdapAuthenticationProviderImpl)new AnonymousAuthenticationProvider("anonymous"));
        ProviderManager authenticationManager = new ProviderManager(providers);
        this.ldapTemplate = new LDAPExtendedTemplate((ContextSource)contextSource);
        if (this.groupMembershipStrategy != null) {
            this.groupMembershipStrategy.setAuthoritiesPopulator((LdapAuthoritiesPopulator)ldapAuthoritiesPopulator);
        }
        return new ApplicationContext((AuthenticationManager)authenticationManager, (LdapUserSearch)ldapUserSearch, (LdapAuthoritiesPopulator)ldapAuthoritiesPopulator);
    }

    @Restricted(value={NoExternalUse.class})
    public LDAPExtendedTemplate getLdapTemplate() {
        return this.ldapTemplate;
    }

    public static final class ApplicationContext {
        public final AuthenticationManager authenticationManager;
        public final LdapUserSearch ldapUserSearch;
        public final LdapAuthoritiesPopulator ldapAuthoritiesPopulator;

        ApplicationContext(AuthenticationManager authenticationManager, LdapUserSearch ldapUserSearch, LdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
            this.authenticationManager = authenticationManager;
            this.ldapUserSearch = ldapUserSearch;
            this.ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
        }
    }

    @Extension
    public static final class LDAPConfigurationDescriptor
    extends Descriptor<LDAPConfiguration> {
        public static final String DEFAULT_DISPLAYNAME_ATTRIBUTE_NAME = "displayname";
        public static final String DEFAULT_MAILADDRESS_ATTRIBUTE_NAME = "mail";
        public static final String DEFAULT_USER_SEARCH = "uid={0}";

        public String getDisplayName() {
            return "ldap";
        }

        public FormValidation doCheckServer(@QueryParameter String value, @QueryParameter String managerDN, @QueryParameter Secret managerPasswordSecret, @QueryParameter String rootDN) {
            String server = value;
            String managerPassword = Secret.toString((Secret)managerPasswordSecret);
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (managerDN != null && managerDN.trim().length() > 0 && !"undefined".equals(managerDN)) {
                    props.put("java.naming.security.principal", managerDN);
                }
                if (managerPassword != null && managerPassword.trim().length() > 0 && !"undefined".equals(managerPassword)) {
                    props.put("java.naming.security.credentials", managerPassword);
                }
                props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                props.put("java.naming.provider.url", LDAPSecurityRealm.toProviderUrl(server, rootDN));
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.getAttributes("");
                return FormValidation.ok();
            }
            catch (NamingException e) {
                Matcher m = Pattern.compile("(ldaps?://)?([^:]+)(?:\\:(\\d+))?(\\s+(ldaps?://)?([^:]+)(?:\\:(\\d+))?)*").matcher(server.trim());
                if (!m.matches()) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_SyntaxOfServerField());
                }
                try {
                    int port;
                    InetAddress address = InetAddress.getByName(m.group(2));
                    int n = port = m.group(1) != null ? 636 : 389;
                    if (m.group(3) != null) {
                        port = Integer.parseInt(m.group(3));
                    }
                    Socket s = new Socket(address, port);
                    s.close();
                }
                catch (UnknownHostException x) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_UnknownHost(x.getMessage()));
                }
                catch (IOException x) {
                    return FormValidation.error((Throwable)x, (String)Messages.LDAPSecurityRealm_UnableToConnect(server, x.getMessage()));
                }
                return FormValidation.error((Throwable)e, (String)Messages.LDAPSecurityRealm_UnableToConnect(server, e));
            }
            catch (NumberFormatException x) {
                return FormValidation.error((String)Messages.LDAPSecurityRealm_InvalidPortNumber());
            }
        }

        public DescriptorExtensionList<LDAPGroupMembershipStrategy, Descriptor<LDAPGroupMembershipStrategy>> getGroupMembershipStrategies() {
            return Jenkins.get().getDescriptorList(LDAPGroupMembershipStrategy.class);
        }
    }
}

