/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.BindAuthenticator;

public class BindAuthenticator2
extends BindAuthenticator {
    private boolean hadSuccessfulAuthentication;
    private static final Logger LOGGER = Logger.getLogger(BindAuthenticator2.class.getName());

    public BindAuthenticator2(BaseLdapPathContextSource contextSource) {
        super(contextSource);
    }

    public DirContextOperations authenticate(Authentication authentication) {
        DirContextOperations operations = super.authenticate(authentication);
        this.hadSuccessfulAuthentication = true;
        return operations;
    }

    protected void handleBindException(String userDn, String username, Throwable cause) {
        LOGGER.log(this.hadSuccessfulAuthentication ? Level.FINE : Level.WARNING, "Failed to bind to LDAP: userDn" + userDn + "  username=" + username, cause);
        super.handleBindException(userDn, username, cause);
    }
}

