/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.GeneralizedTime;
import hudson.security.LDAPSecurityRealm;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

final class UserAttributesHelper {
    private static final String ATTR_USER_ACCOUNT_CONTROL = "userAccountControl";
    private static final String ATTR_ACCOUNT_EXPIRES = "accountExpires";
    private static final String ATTR_LOGIN_DISABLED = "loginDisabled";
    private static final String ATTR_ORACLE_IS_ENABLED = "orclIsEnabled";
    private static final String ATTR_PWD_ACCOUNT_LOCKED_TIME = "pwdAccountLockedTime";
    private static final String ATTR_PWD_START_TIME = "pwdStartTime";
    private static final String ATTR_PWD_END_TIME = "pwdEndTime";
    private static final String ATTR_LOGIN_EXPIRATION_TIME = "loginExpirationTime";
    private static final String ATTR_PWD_LOCKOUT = "pwdLockout";
    private static final String ATTR_LOCKED_BY_INTRUDER = "lockedByIntruder";
    private static final String ATTR_USER_ACCOUNT_CONTROL_COMPUTED = "msDS-User-Account-Control-Computed";
    private static final String ATTR_USER_ACCOUNT_DISABLED = "msDS-UserAccountDisabled";
    private static final String ATTR_USER_PASSWORD_EXPIRED = "msDS-UserPasswordExpired";
    private static final String ACCOUNT_DISABLED = "000001010000Z";
    private static final long ACCOUNT_NO_EXPIRATION = Long.MAX_VALUE;
    private static final int ADS_UF_DISABLED = 2;
    private static final int ADS_UF_LOCK_OUT = 16;
    private static final int ADS_DONT_EXPIRE_PASSWORD = 65536;
    private static final int ADS_UF_PASSWORD_EXPIRED = 0x800000;

    public static boolean checkIfUserEnabled(@NonNull Attributes user) {
        Integer uac = UserAttributesHelper.getUserAccountControl(user);
        if (uac != null && (uac & 2) == 2) {
            return false;
        }
        String accountDisabled = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_DISABLED);
        if (accountDisabled != null) {
            return !Boolean.parseBoolean(accountDisabled);
        }
        if (ACCOUNT_DISABLED.equals(UserAttributesHelper.getStringAttribute(user, ATTR_PWD_ACCOUNT_LOCKED_TIME))) {
            return false;
        }
        String loginDisabled = UserAttributesHelper.getStringAttribute(user, ATTR_LOGIN_DISABLED);
        if (loginDisabled != null) {
            return !Boolean.parseBoolean(loginDisabled);
        }
        String oracleIsEnabled = UserAttributesHelper.getStringAttribute(user, ATTR_ORACLE_IS_ENABLED);
        return oracleIsEnabled == null || oracleIsEnabled.equalsIgnoreCase("enabled");
    }

    public static boolean checkIfAccountNonExpired(@NonNull Attributes user) {
        String accountExpirationDate = UserAttributesHelper.getStringAttribute(user, ATTR_ACCOUNT_EXPIRES);
        if (accountExpirationDate != null) {
            long expirationAsLong = Long.parseLong(accountExpirationDate);
            if (expirationAsLong == 0L || expirationAsLong == Long.MAX_VALUE) {
                return true;
            }
            long nowIn100NsFromJan1601 = UserAttributesHelper.getWin32EpochHundredNanos();
            return expirationAsLong > nowIn100NsFromJan1601;
        }
        GeneralizedTime now = GeneralizedTime.now();
        GeneralizedTime startTime = UserAttributesHelper.getGeneralizedTimeAttribute(user, ATTR_PWD_START_TIME);
        if (startTime != null && startTime.isAfter(now)) {
            return false;
        }
        GeneralizedTime endTime = UserAttributesHelper.getGeneralizedTimeAttribute(user, ATTR_PWD_END_TIME);
        if (endTime != null) {
            return endTime.isAfter(now);
        }
        GeneralizedTime loginExpirationTime = UserAttributesHelper.getGeneralizedTimeAttribute(user, ATTR_LOGIN_EXPIRATION_TIME);
        return loginExpirationTime == null || loginExpirationTime.isAfter(now);
    }

    public static boolean checkIfCredentialsNonExpired(@NonNull Attributes user) {
        String passwordExpired;
        Integer uac = UserAttributesHelper.getUserAccountControl(user);
        if (uac != null) {
            if ((uac & 0x10000) == 65536) {
                return true;
            }
            if ((uac & 0x800000) == 0x800000) {
                return false;
            }
        }
        return !Boolean.parseBoolean(passwordExpired = UserAttributesHelper.getStringAttribute(user, ATTR_USER_PASSWORD_EXPIRED));
    }

    public static boolean checkIfAccountNonLocked(@NonNull Attributes user) {
        Integer uac = UserAttributesHelper.getUserAccountControl(user);
        if (uac != null && (uac & 0x10) == 16) {
            return false;
        }
        String lockout = UserAttributesHelper.getStringAttribute(user, ATTR_PWD_LOCKOUT);
        if (lockout != null) {
            return !Boolean.parseBoolean(lockout);
        }
        String lockedByIntruder = UserAttributesHelper.getStringAttribute(user, ATTR_LOCKED_BY_INTRUDER);
        return !Boolean.parseBoolean(lockedByIntruder);
    }

    private static long getWin32EpochHundredNanos() {
        GregorianCalendar win32Epoch = new GregorianCalendar(1601, 0, 1);
        Date win32EpochDate = win32Epoch.getTime();
        GregorianCalendar today = new GregorianCalendar();
        Date todayDate = today.getTime();
        long timeSinceWin32EpochInMs = todayDate.getTime() - win32EpochDate.getTime();
        long timeSinceWin32EpochInNs = TimeUnit.NANOSECONDS.convert(timeSinceWin32EpochInMs, TimeUnit.MILLISECONDS);
        return timeSinceWin32EpochInNs * 100L;
    }

    @CheckForNull
    private static Integer getUserAccountControl(@NonNull Attributes user) {
        String uac = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL);
        String computedUac = UserAttributesHelper.getStringAttribute(user, ATTR_USER_ACCOUNT_CONTROL_COMPUTED);
        if (uac == null) {
            return computedUac == null ? null : Integer.valueOf(Integer.parseInt(computedUac));
        }
        if (computedUac == null) {
            return Integer.parseInt(uac);
        }
        return Integer.parseInt(uac) | Integer.parseInt(computedUac);
    }

    @CheckForNull
    private static GeneralizedTime getGeneralizedTimeAttribute(@NonNull Attributes user, @NonNull String attrName) {
        String timestamp = UserAttributesHelper.getStringAttribute(user, attrName);
        try {
            return timestamp == null ? null : GeneralizedTime.parse(timestamp);
        }
        catch (ParseException e) {
            LDAPSecurityRealm.LOGGER.log(Level.WARNING, e, () -> "Invalid format found parsing generalized time attribute " + attrName + " with value '" + timestamp + "'");
            return null;
        }
    }

    @CheckForNull
    private static String getStringAttribute(@NonNull Attributes user, @NonNull String attrName) {
        Attribute a = user.get(attrName);
        if (a == null || a.size() == 0) {
            return null;
        }
        try {
            Object v = a.get();
            return v == null ? null : v.toString();
        }
        catch (NamingException e) {
            return null;
        }
    }

    private UserAttributesHelper() {
        throw new UnsupportedOperationException();
    }
}

