/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import hudson.Extension;
import hudson.security.LDAPSecurityRealm;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import jenkins.security.plugins.ldap.LDAPConfiguration;
import jenkins.security.plugins.ldap.LDAPExtendedTemplate;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategyDescriptor;
import jenkins.security.plugins.ldap.Messages;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ldap.LdapEntryMapper;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class FromGroupSearchLDAPGroupMembershipStrategy
extends LDAPGroupMembershipStrategy {
    private static final Logger LOGGER = Logger.getLogger(FromGroupSearchLDAPGroupMembershipStrategy.class.getName());
    private final String filter;

    @DataBoundConstructor
    public FromGroupSearchLDAPGroupMembershipStrategy(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        if (authoritiesPopulator instanceof LDAPSecurityRealm.AuthoritiesPopulatorImpl && StringUtils.isNotBlank((String)this.filter)) {
            ((LDAPSecurityRealm.AuthoritiesPopulatorImpl)authoritiesPopulator).setGroupSearchFilter(this.filter);
        }
        super.setAuthoritiesPopulator(authoritiesPopulator);
    }

    @Override
    public GrantedAuthority[] getGrantedAuthorities(LdapUserDetails ldapUser) {
        return this.getAuthoritiesPopulator().getGrantedAuthorities(ldapUser);
    }

    @Override
    public Set<String> getGroupMembers(String groupDn, LDAPConfiguration conf) throws DataAccessException {
        LDAPExtendedTemplate template = conf.getLdapTemplate();
        String[] memberAttributes = new String[]{"member", "uniqueMember", "memberUid"};
        return (Set)template.retrieveEntry(groupDn, new GroupMembersMapper(), memberAttributes);
    }

    private static class GroupMembersMapper
    implements LdapEntryMapper {
        private GroupMembersMapper() {
        }

        public Set<String> mapAttributes(String dn, Attributes attributes) throws NamingException {
            NamingEnumeration<?> enumeration;
            boolean expectingUidInsteadOfDn = false;
            if (attributes.get("member") != null) {
                enumeration = attributes.get("member").getAll();
            } else if (attributes.get("uniqueMember") != null) {
                enumeration = attributes.get("uniqueMember").getAll();
            } else if (attributes.get("memberUid") != null) {
                enumeration = attributes.get("memberUid").getAll();
                expectingUidInsteadOfDn = true;
            } else {
                LOGGER.log(Level.FINEST, "No members for {0}", dn);
                return Collections.emptySet();
            }
            TreeSet<String> members = new TreeSet<String>();
            while (enumeration.hasMore()) {
                String memberDn = String.valueOf(enumeration.next());
                if (expectingUidInsteadOfDn) {
                    members.add(memberDn);
                    continue;
                }
                try {
                    LdapName memberName = new LdapName(memberDn);
                    members.add(String.valueOf(memberName.getRdn(memberName.size() - 1).getValue()));
                }
                catch (InvalidNameException e) {
                    LOGGER.log(Level.FINEST, "Expecting DN but found {0}", memberDn);
                }
            }
            return members;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends LDAPGroupMembershipStrategyDescriptor {
        public String getDisplayName() {
            return Messages.FromGroupSearchLDAPGroupMembershipStrategy_DisplayName();
        }
    }
}

