/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import groovy.lang.Binding;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.Messages;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.MailAddressResolver;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import hudson.util.spring.BeanBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import jenkins.model.Jenkins;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class LDAPSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String server;
    public final String rootDN;
    public final boolean inhibitInferRootDN;
    public final String userSearchBase;
    public final String userSearch;
    public final String groupSearchBase;
    public final String managerDN;
    private final String managerPassword;
    private transient LdapTemplate ldapTemplate;
    private static final Logger LOGGER = Logger.getLogger(LDAPSecurityRealm.class.getName());
    public static String GROUP_SEARCH = System.getProperty(LDAPSecurityRealm.class.getName() + ".groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");

    @DataBoundConstructor
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN) {
        this.server = server.trim();
        this.managerDN = Util.fixEmpty((String)managerDN);
        this.managerPassword = Scrambler.scramble((String)Util.fixEmpty((String)managerPassword));
        this.inhibitInferRootDN = inhibitInferRootDN;
        if (!inhibitInferRootDN && Util.fixEmptyAndTrim((String)rootDN) == null) {
            rootDN = Util.fixNull((String)this.inferRootDN(server));
        }
        this.rootDN = rootDN.trim();
        this.userSearchBase = Util.fixNull((String)userSearchBase).trim();
        this.userSearch = (userSearch = Util.fixEmptyAndTrim((String)userSearch)) != null ? userSearch : "uid={0}";
        this.groupSearchBase = Util.fixEmptyAndTrim((String)groupSearchBase);
    }

    public String getServerUrl() {
        return LDAPSecurityRealm.addPrefix(this.server);
    }

    private String inferRootDN(String server) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.managerDN != null) {
                props.put("java.naming.security.principal", this.managerDN);
                props.put("java.naming.security.credentials", this.getManagerPassword());
            }
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.provider.url", this.getServerUrl() + '/');
            InitialDirContext ctx = new InitialDirContext(props);
            Attributes atts = ctx.getAttributes("");
            Attribute a = atts.get("defaultNamingContext");
            if (a != null && a.get() != null) {
                return a.get().toString();
            }
            a = atts.get("namingcontexts");
            if (a == null) {
                LOGGER.warning("namingcontexts attribute not found in root DSE of " + server);
                return null;
            }
            return a.get().toString();
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to LDAP to infer Root DN for " + server, e);
            return null;
        }
    }

    public String getManagerPassword() {
        return Scrambler.descramble((String)this.managerPassword);
    }

    public String getLDAPURL() {
        return this.getServerUrl() + '/' + Util.fixNull((String)this.rootDN);
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        Binding binding = new Binding();
        binding.setVariable("instance", (Object)this);
        BeanBuilder builder = new BeanBuilder(Jenkins.getInstance().pluginManager.uberClassLoader);
        String fileName = "LDAPBindSecurityRealm.groovy";
        try {
            File override = new File(Jenkins.getInstance().getRootDir(), fileName);
            builder.parse((InputStream)(override.exists() ? new AutoCloseInputStream((InputStream)new FileInputStream(override)) : ((Object)((Object)this)).getClass().getResourceAsStream(fileName)), binding);
        }
        catch (FileNotFoundException e) {
            throw new Error("Failed to load " + fileName, e);
        }
        WebApplicationContext appContext = builder.createApplicationContext();
        this.ldapTemplate = new LdapTemplate((InitialDirContextFactory)LDAPSecurityRealm.findBean(InitialDirContextFactory.class, (ApplicationContext)appContext));
        return new SecurityRealm.SecurityComponents((AuthenticationManager)LDAPSecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext), (UserDetailsService)new LDAPUserDetailsService(appContext));
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        return (UserDetails)this.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password)).getPrincipal();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getSecurityComponents().userDetails.loadUserByUsername(username);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        String searchBase = this.groupSearchBase != null ? this.groupSearchBase : "";
        final Set groups = this.ldapTemplate.searchForSingleAttributeValues(searchBase, GROUP_SEARCH, (Object[])new String[]{groupname}, "cn");
        if (groups.isEmpty()) {
            throw new UsernameNotFoundException(groupname);
        }
        return new GroupDetails(){

            public String getName() {
                return (String)groups.iterator().next();
            }
        };
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return Messages.LDAPSecurityRealm_DisplayName();
        }

        public FormValidation doServerCheck(@QueryParameter String server, @QueryParameter String managerDN, @QueryParameter String managerPassword) {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (managerDN != null && managerDN.trim().length() > 0 && !"undefined".equals(managerDN)) {
                    props.put("java.naming.security.principal", managerDN);
                }
                if (managerPassword != null && managerPassword.trim().length() > 0 && !"undefined".equals(managerPassword)) {
                    props.put("java.naming.security.credentials", managerPassword);
                }
                props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                props.put("java.naming.provider.url", LDAPSecurityRealm.addPrefix(server) + '/');
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.getAttributes("");
                return FormValidation.ok();
            }
            catch (NamingException e) {
                Matcher m = Pattern.compile("(ldaps://)?([^:]+)(?:\\:(\\d+))?").matcher(server.trim());
                if (!m.matches()) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_SyntaxOfServerField());
                }
                try {
                    int port;
                    InetAddress adrs = InetAddress.getByName(m.group(2));
                    int n = port = m.group(1) != null ? 636 : 389;
                    if (m.group(3) != null) {
                        port = Integer.parseInt(m.group(3));
                    }
                    Socket s = new Socket(adrs, port);
                    s.close();
                }
                catch (UnknownHostException x) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_UnknownHost((Object)x.getMessage()));
                }
                catch (IOException x) {
                    return FormValidation.error((Throwable)x, (String)Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)x.getMessage()));
                }
                return FormValidation.error((Throwable)e, (String)Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)e));
            }
            catch (NumberFormatException x) {
                return FormValidation.error((String)Messages.LDAPSecurityRealm_InvalidPortNumber());
            }
        }
    }

    public static final class AuthoritiesPopulatorImpl
    extends DefaultLdapAuthoritiesPopulator {
        String rolePrefix = "ROLE_";
        boolean convertToUpperCase = true;

        public AuthoritiesPopulatorImpl(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
            super(initialDirContextFactory, Util.fixNull((String)groupSearchBase));
            super.setRolePrefix("");
            super.setConvertToUpperCase(false);
        }

        protected Set getAdditionalRoles(LdapUserDetails ldapUser) {
            return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY);
        }

        public void setRolePrefix(String rolePrefix) {
            this.rolePrefix = rolePrefix;
        }

        public void setConvertToUpperCase(boolean convertToUpperCase) {
            this.convertToUpperCase = convertToUpperCase;
        }

        public Set getGroupMembershipRoles(String userDn, String username) {
            Set names = super.getGroupMembershipRoles(userDn, username);
            HashSet<GrantedAuthorityImpl> r = new HashSet<GrantedAuthorityImpl>(names.size() * 2);
            r.addAll(names);
            for (GrantedAuthority ga : names) {
                String role = ga.getAuthority();
                if (this.convertToUpperCase) {
                    role = role.toUpperCase();
                }
                r.add(new GrantedAuthorityImpl(this.rolePrefix + role));
            }
            return r;
        }
    }

    @Extension
    public static final class MailAdressResolverImpl
    extends MailAddressResolver {
        public String findMailAddressFor(User u) {
            SecurityRealm realm = Jenkins.getInstance().getSecurityRealm();
            if (!(realm instanceof LDAPSecurityRealm)) {
                return null;
            }
            try {
                LdapUserDetails details = (LdapUserDetails)realm.getSecurityComponents().userDetails.loadUserByUsername(u.getId());
                Attribute mail = details.getAttributes().get("mail");
                if (mail == null) {
                    return null;
                }
                return (String)mail.get();
            }
            catch (UsernameNotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (DataAccessException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (NamingException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (AcegiSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
        }
    }

    public static class LDAPUserDetailsService
    implements UserDetailsService {
        public final LdapUserSearch ldapSearch;
        public final LdapAuthoritiesPopulator authoritiesPopulator;
        private final LRUMap attributesCache = new LRUMap(32);

        LDAPUserDetailsService(WebApplicationContext appContext) {
            this.ldapSearch = (LdapUserSearch)SecurityRealm.findBean(LdapUserSearch.class, (ApplicationContext)appContext);
            this.authoritiesPopulator = (LdapAuthoritiesPopulator)SecurityRealm.findBean(LdapAuthoritiesPopulator.class, (ApplicationContext)appContext);
        }

        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
            this.ldapSearch = ldapSearch;
            this.authoritiesPopulator = authoritiesPopulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LdapUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            try {
                LdapUserDetails ldapUser = this.ldapSearch.searchForUser(username);
                if (ldapUser != null) {
                    GrantedAuthority[] extraAuthorities;
                    LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                    Attributes v = ldapUser.getAttributes();
                    if (v instanceof BasicAttributes) {
                        LRUMap lRUMap = this.attributesCache;
                        synchronized (lRUMap) {
                            Attributes vv = (Attributes)this.attributesCache.get((Object)v);
                            if (vv == null) {
                                vv = v;
                                this.attributesCache.put((Object)v, (Object)vv);
                            }
                            user.setAttributes(vv);
                        }
                    }
                    for (GrantedAuthority extraAuthority : extraAuthorities = this.authoritiesPopulator.getGrantedAuthorities(ldapUser)) {
                        user.addAuthority(extraAuthority);
                    }
                    ldapUser = user.createUserDetails();
                }
                return ldapUser;
            }
            catch (LdapDataAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to search LDAP for username=" + username, e);
                throw new UserMayOrMayNotExistException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

