/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.cli;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubectlCredential
extends AbstractDescribableImpl<KubectlCredential> {
    public static final CredentialsMatcher supportedCredentials = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(TokenProducer.class), CredentialsMatchers.instanceOf(StringCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(FileCredentials.class)});
    @DataBoundSetter
    public String serverUrl;
    @DataBoundSetter
    public String credentialsId;
    @DataBoundSetter
    public String caCertificate;
    @DataBoundSetter
    public String contextName;
    @DataBoundSetter
    public String clusterName;
    @DataBoundSetter
    public String namespace;

    @DataBoundConstructor
    public KubectlCredential() {
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KubectlCredential> {
        public String getDisplayName() {
            return "";
        }

        public ListBoxModel doFillCredentialsIdItems(@Nonnull @AncestorInPath Item item, @QueryParameter String serverUrl) {
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), supportedCredentials);
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String credentialsId) throws IOException, ServletException {
            if (Strings.isNullOrEmpty((String)credentialsId)) {
                return FormValidation.error((String)"The credentialId cannot be empty");
            }
            return FormValidation.ok();
        }
    }
}

