/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.V2beta2ResourceUpdateMonitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AutoscalingV2beta2Api;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V2beta2HorizontalPodAutoscaler;

public class V2beta2ResourceManager
extends ResourceManager {
    private final AutoscalingV2beta2Api autoscalingV2beta2Api;
    private V2beta2ResourceUpdateMonitor resourceUpdateMonitor = V2beta2ResourceUpdateMonitor.NOOP;

    public V2beta2ResourceManager(ApiClient client) {
        super(true);
        Preconditions.checkNotNull((Object)client);
        this.autoscalingV2beta2Api = new AutoscalingV2beta2Api(client);
    }

    public V2beta2ResourceManager(ApiClient client, boolean pretty) {
        super(pretty);
        Preconditions.checkNotNull((Object)client);
        this.autoscalingV2beta2Api = new AutoscalingV2beta2Api(client);
    }

    public V2beta2ResourceUpdateMonitor getResourceUpdateMonitor() {
        return this.resourceUpdateMonitor;
    }

    public V2beta2ResourceManager withResourceUpdateMonitor(V2beta2ResourceUpdateMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.resourceUpdateMonitor = monitor;
        return this;
    }

    class HorizontalPodAutoscalerUpdater
    extends ResourceManager.ResourceUpdater<V2beta2HorizontalPodAutoscaler> {
        HorizontalPodAutoscalerUpdater(V2beta2HorizontalPodAutoscaler namespace) {
            super(namespace);
        }

        @Override
        V2beta2HorizontalPodAutoscaler getCurrentResource() {
            V2beta2HorizontalPodAutoscaler result = null;
            try {
                result = V2beta2ResourceManager.this.autoscalingV2beta2Api.readNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), V2beta2ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V2beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V2beta2HorizontalPodAutoscaler applyResource(V2beta2HorizontalPodAutoscaler original, V2beta2HorizontalPodAutoscaler current) {
            V2beta2HorizontalPodAutoscaler result = null;
            try {
                result = V2beta2ResourceManager.this.autoscalingV2beta2Api.replaceNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), current, V2beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V2beta2ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V2beta2HorizontalPodAutoscaler createResource(V2beta2HorizontalPodAutoscaler current) {
            V2beta2HorizontalPodAutoscaler result = null;
            try {
                result = V2beta2ResourceManager.this.autoscalingV2beta2Api.createNamespacedHorizontalPodAutoscaler(this.getNamespace(), current, V2beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V2beta2ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V2beta2HorizontalPodAutoscaler current) {
            V1Status result = null;
            try {
                result = V2beta2ResourceManager.this.autoscalingV2beta2Api.deleteNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), V2beta2ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V2beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V2beta2HorizontalPodAutoscaler original, V2beta2HorizontalPodAutoscaler current) {
            V2beta2ResourceManager.this.resourceUpdateMonitor.onHorizontalPodAutoscalerUpdate(original, current);
        }
    }
}

