/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.V2beta1ResourceUpdateMonitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AutoscalingV2beta1Api;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V2beta1HorizontalPodAutoscaler;

public class V2beta1ResourceManager
extends ResourceManager {
    private final AutoscalingV2beta1Api autoscalingV2beta1Api;
    private V2beta1ResourceUpdateMonitor resourceUpdateMonitor = V2beta1ResourceUpdateMonitor.NOOP;

    public V2beta1ResourceManager(ApiClient client) {
        super(true);
        Preconditions.checkNotNull((Object)client);
        this.autoscalingV2beta1Api = new AutoscalingV2beta1Api(client);
    }

    public V2beta1ResourceManager(ApiClient client, boolean pretty) {
        super(pretty);
        Preconditions.checkNotNull((Object)client);
        this.autoscalingV2beta1Api = new AutoscalingV2beta1Api(client);
    }

    public V2beta1ResourceUpdateMonitor getResourceUpdateMonitor() {
        return this.resourceUpdateMonitor;
    }

    public V2beta1ResourceManager withResourceUpdateMonitor(V2beta1ResourceUpdateMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.resourceUpdateMonitor = monitor;
        return this;
    }

    class HorizontalPodAutoscalerUpdater
    extends ResourceManager.ResourceUpdater<V2beta1HorizontalPodAutoscaler> {
        HorizontalPodAutoscalerUpdater(V2beta1HorizontalPodAutoscaler namespace) {
            super(namespace);
        }

        @Override
        V2beta1HorizontalPodAutoscaler getCurrentResource() {
            V2beta1HorizontalPodAutoscaler result = null;
            try {
                result = V2beta1ResourceManager.this.autoscalingV2beta1Api.readNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), V2beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V2beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V2beta1HorizontalPodAutoscaler applyResource(V2beta1HorizontalPodAutoscaler original, V2beta1HorizontalPodAutoscaler current) {
            V2beta1HorizontalPodAutoscaler result = null;
            try {
                result = V2beta1ResourceManager.this.autoscalingV2beta1Api.replaceNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), current, V2beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V2beta1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V2beta1HorizontalPodAutoscaler createResource(V2beta1HorizontalPodAutoscaler current) {
            V2beta1HorizontalPodAutoscaler result = null;
            try {
                result = V2beta1ResourceManager.this.autoscalingV2beta1Api.createNamespacedHorizontalPodAutoscaler(this.getNamespace(), current, V2beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V2beta1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V2beta1HorizontalPodAutoscaler current) {
            V1Status result = null;
            try {
                result = V2beta1ResourceManager.this.autoscalingV2beta1Api.deleteNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), V2beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V2beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V2beta1HorizontalPodAutoscaler original, V2beta1HorizontalPodAutoscaler current) {
            V2beta1ResourceManager.this.resourceUpdateMonitor.onHorizontalPodAutoscalerUpdate(original, current);
        }
    }
}

