/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.V2alpha1ResourceUpdateMonitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.BatchV2alpha1Api;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V2alpha1CronJob;

public class V2alpha1ResourceManager
extends ResourceManager {
    private final BatchV2alpha1Api batchV2alpha1Api;
    private V2alpha1ResourceUpdateMonitor resourceUpdateMonitor = V2alpha1ResourceUpdateMonitor.NOOP;

    public V2alpha1ResourceManager(ApiClient client) {
        super(true);
        Preconditions.checkNotNull((Object)client);
        this.batchV2alpha1Api = new BatchV2alpha1Api(client);
    }

    public V2alpha1ResourceManager(ApiClient client, boolean pretty) {
        super(pretty);
        Preconditions.checkNotNull((Object)client);
        this.batchV2alpha1Api = new BatchV2alpha1Api(client);
    }

    public V2alpha1ResourceUpdateMonitor getResourceUpdateMonitor() {
        return this.resourceUpdateMonitor;
    }

    public V2alpha1ResourceManager withResourceUpdateMonitor(V2alpha1ResourceUpdateMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.resourceUpdateMonitor = monitor;
        return this;
    }

    class CronJobUpdater
    extends ResourceManager.ResourceUpdater<V2alpha1CronJob> {
        CronJobUpdater(V2alpha1CronJob namespace) {
            super(namespace);
        }

        @Override
        V2alpha1CronJob getCurrentResource() {
            V2alpha1CronJob result = null;
            try {
                result = V2alpha1ResourceManager.this.batchV2alpha1Api.readNamespacedCronJob(this.getName(), this.getNamespace(), V2alpha1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V2alpha1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V2alpha1CronJob applyResource(V2alpha1CronJob original, V2alpha1CronJob current) {
            V2alpha1CronJob result = null;
            try {
                result = V2alpha1ResourceManager.this.batchV2alpha1Api.replaceNamespacedCronJob(this.getName(), this.getNamespace(), current, V2alpha1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V2alpha1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V2alpha1CronJob createResource(V2alpha1CronJob current) {
            V2alpha1CronJob result = null;
            try {
                result = V2alpha1ResourceManager.this.batchV2alpha1Api.createNamespacedCronJob(this.getNamespace(), current, V2alpha1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V2alpha1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V2alpha1CronJob current) {
            V1Status result = null;
            try {
                result = V2alpha1ResourceManager.this.batchV2alpha1Api.deleteNamespacedCronJob(this.getName(), this.getNamespace(), V2alpha1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V2alpha1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V2alpha1CronJob original, V2alpha1CronJob current) {
            V2alpha1ResourceManager.this.resourceUpdateMonitor.onCronJobUpdate(original, current);
        }
    }
}

