/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ClusterRoleBinding;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscaler;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1NetworkPolicy;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1StatefulSet;

public interface V1ResourceUpdateMonitor {
    public static final V1ResourceUpdateMonitor NOOP = new Adapter();

    public void onSecretUpdate(V1Secret var1, V1Secret var2);

    public void onDeploymentUpdate(V1Deployment var1, V1Deployment var2);

    public void onServiceUpdate(V1Service var1, V1Service var2);

    public void onReplicationControllerUpdate(V1ReplicationController var1, V1ReplicationController var2);

    public void onReplicaSetUpdate(V1ReplicaSet var1, V1ReplicaSet var2);

    public void onDaemonSetUpdate(V1DaemonSet var1, V1DaemonSet var2);

    public void onJobUpdate(V1Job var1, V1Job var2);

    public void onPodUpdate(V1Pod var1, V1Pod var2);

    public void onConfigMapUpdate(V1ConfigMap var1, V1ConfigMap var2);

    public void onNamespaceUpdate(V1Namespace var1, V1Namespace var2);

    public void onHorizontalPodAutoscalerUpdate(V1HorizontalPodAutoscaler var1, V1HorizontalPodAutoscaler var2);

    public void onPersistentVolumeClaimUpdate(V1PersistentVolumeClaim var1, V1PersistentVolumeClaim var2);

    public void onPersistentVolumeUpdate(V1PersistentVolume var1, V1PersistentVolume var2);

    public void onStatefulSetUpdate(V1StatefulSet var1, V1StatefulSet var2);

    public void onNetworkPolicyUpdate(V1NetworkPolicy var1, V1NetworkPolicy var2);

    public void onRoleUpdate(V1Role var1, V1Role var2);

    public void onRoleBindingUpdate(V1RoleBinding var1, V1RoleBinding var2);

    public void onServiceAccountUpdate(V1ServiceAccount var1, V1ServiceAccount var2);

    public void onClusterRoleUpdate(V1ClusterRole var1, V1ClusterRole var2);

    public void onClusterRoleBindingUpdate(V1ClusterRoleBinding var1, V1ClusterRoleBinding var2);

    public static class Adapter
    implements V1ResourceUpdateMonitor {
        @Override
        public void onSecretUpdate(V1Secret original, V1Secret current) {
        }

        @Override
        public void onDeploymentUpdate(V1Deployment original, V1Deployment current) {
        }

        @Override
        public void onServiceUpdate(V1Service original, V1Service current) {
        }

        @Override
        public void onReplicationControllerUpdate(V1ReplicationController original, V1ReplicationController current) {
        }

        @Override
        public void onReplicaSetUpdate(V1ReplicaSet original, V1ReplicaSet current) {
        }

        @Override
        public void onDaemonSetUpdate(V1DaemonSet original, V1DaemonSet current) {
        }

        @Override
        public void onJobUpdate(V1Job original, V1Job current) {
        }

        @Override
        public void onPodUpdate(V1Pod original, V1Pod current) {
        }

        @Override
        public void onConfigMapUpdate(V1ConfigMap original, V1ConfigMap current) {
        }

        @Override
        public void onNamespaceUpdate(V1Namespace original, V1Namespace current) {
        }

        @Override
        public void onHorizontalPodAutoscalerUpdate(V1HorizontalPodAutoscaler original, V1HorizontalPodAutoscaler current) {
        }

        @Override
        public void onStatefulSetUpdate(V1StatefulSet original, V1StatefulSet current) {
        }

        @Override
        public void onPersistentVolumeClaimUpdate(V1PersistentVolumeClaim original, V1PersistentVolumeClaim current) {
        }

        @Override
        public void onPersistentVolumeUpdate(V1PersistentVolume original, V1PersistentVolume current) {
        }

        @Override
        public void onNetworkPolicyUpdate(V1NetworkPolicy original, V1NetworkPolicy current) {
        }

        @Override
        public void onRoleUpdate(V1Role original, V1Role current) {
        }

        @Override
        public void onRoleBindingUpdate(V1RoleBinding original, V1RoleBinding current) {
        }

        @Override
        public void onServiceAccountUpdate(V1ServiceAccount original, V1ServiceAccount current) {
        }

        @Override
        public void onClusterRoleUpdate(V1ClusterRole original, V1ClusterRole current) {
        }

        @Override
        public void onClusterRoleBindingUpdate(V1ClusterRoleBinding original, V1ClusterRoleBinding current) {
        }
    }
}

