/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.util.KubernetesJsonUtils;
import com.microsoft.jenkins.kubernetes.wrapper.Messages;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.V1ResourceUpdateMonitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.AutoscalingV1Api;
import io.kubernetes.client.openapi.apis.BatchV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRole;
import io.kubernetes.client.openapi.models.V1ClusterRoleBinding;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscaler;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1NetworkPolicy;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import io.kubernetes.client.openapi.models.V1Role;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1Status;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class V1ResourceManager
extends ResourceManager {
    private final CoreV1Api coreV1ApiInstance;
    private final AppsV1Api appsV1ApiInstance;
    private final BatchV1Api batchV1ApiInstance;
    private final AutoscalingV1Api autoscalingV1Api;
    private final NetworkingV1Api networkingV1Api;
    private final RbacAuthorizationV1Api rbacV1Api;
    private V1ResourceUpdateMonitor resourceUpdateMonitor = V1ResourceUpdateMonitor.NOOP;

    public V1ResourceManager(ApiClient client) {
        super(true);
        Preconditions.checkNotNull((Object)client);
        this.coreV1ApiInstance = new CoreV1Api(client);
        this.appsV1ApiInstance = new AppsV1Api(client);
        this.batchV1ApiInstance = new BatchV1Api(client);
        this.autoscalingV1Api = new AutoscalingV1Api(client);
        this.networkingV1Api = new NetworkingV1Api(client);
        this.rbacV1Api = new RbacAuthorizationV1Api(client);
    }

    public V1ResourceManager(ApiClient client, boolean pretty) {
        super(pretty);
        Preconditions.checkNotNull((Object)client);
        this.coreV1ApiInstance = new CoreV1Api(client);
        this.appsV1ApiInstance = new AppsV1Api(client);
        this.batchV1ApiInstance = new BatchV1Api(client);
        this.autoscalingV1Api = new AutoscalingV1Api(client);
        this.networkingV1Api = new NetworkingV1Api(client);
        this.rbacV1Api = new RbacAuthorizationV1Api(client);
    }

    private static void recoverPodImagePullPolicy(V1PodSpec origin, V1PodSpec yaml, V1PodSpec target) {
        int i;
        if (origin.getInitContainers() != null) {
            Preconditions.checkNotNull((Object)yaml.getInitContainers());
            Preconditions.checkNotNull((Object)target.getInitContainers());
            if (origin.getInitContainers().size() != yaml.getInitContainers().size() || origin.getInitContainers().size() != target.getInitContainers().size()) {
                return;
            }
            for (i = 0; i < origin.getInitContainers().size(); ++i) {
                if (!StringUtils.isBlank((CharSequence)((V1Container)yaml.getInitContainers().get(i)).getImagePullPolicy())) continue;
                ((V1Container)target.getInitContainers().get(i)).imagePullPolicy(((V1Container)origin.getInitContainers().get(i)).getImagePullPolicy());
            }
        }
        if (origin.getContainers() != null) {
            Preconditions.checkNotNull((Object)yaml.getContainers());
            Preconditions.checkNotNull((Object)target.getContainers());
            if (origin.getContainers().size() != yaml.getContainers().size() || origin.getContainers().size() != target.getContainers().size()) {
                return;
            }
            for (i = 0; i < origin.getContainers().size(); ++i) {
                if (!StringUtils.isBlank((CharSequence)((V1Container)yaml.getContainers().get(i)).getImagePullPolicy())) continue;
                ((V1Container)target.getContainers().get(i)).imagePullPolicy(((V1Container)origin.getContainers().get(i)).getImagePullPolicy());
            }
        }
    }

    public V1ResourceUpdateMonitor getResourceUpdateMonitor() {
        return this.resourceUpdateMonitor;
    }

    public V1ResourceManager withResourceUpdateMonitor(V1ResourceUpdateMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.resourceUpdateMonitor = monitor;
        return this;
    }

    class ClusterRoleBindingUpdater
    extends ResourceManager.ResourceUpdater<V1ClusterRoleBinding> {
        ClusterRoleBindingUpdater(V1ClusterRoleBinding clusterRoleBinding) {
            super(clusterRoleBinding);
        }

        @Override
        V1ClusterRoleBinding getCurrentResource() {
            V1ClusterRoleBinding result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.readClusterRoleBinding(this.getName(), V1ResourceManager.this.getPretty());
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1ClusterRoleBinding applyResource(V1ClusterRoleBinding original, V1ClusterRoleBinding current) {
            V1ClusterRoleBinding result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.replaceClusterRoleBinding(this.getName(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1ClusterRoleBinding createResource(V1ClusterRoleBinding current) {
            V1ClusterRoleBinding result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.createClusterRoleBinding(current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1ClusterRoleBinding current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.deleteClusterRoleBinding(this.getName(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1ClusterRoleBinding original, V1ClusterRoleBinding current) {
            V1ResourceManager.this.resourceUpdateMonitor.onClusterRoleBindingUpdate(original, current);
        }
    }

    class ClusterRoleUpdater
    extends ResourceManager.ResourceUpdater<V1ClusterRole> {
        ClusterRoleUpdater(V1ClusterRole clusterRole) {
            super(clusterRole);
        }

        @Override
        V1ClusterRole getCurrentResource() {
            V1ClusterRole result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.readClusterRole(this.getName(), V1ResourceManager.this.getPretty());
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1ClusterRole applyResource(V1ClusterRole original, V1ClusterRole current) {
            V1ClusterRole result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.replaceClusterRole(this.getName(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1ClusterRole createResource(V1ClusterRole current) {
            V1ClusterRole result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.createClusterRole(current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1ClusterRole current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.deleteClusterRole(this.getName(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1ClusterRole original, V1ClusterRole current) {
            V1ResourceManager.this.resourceUpdateMonitor.onClusterRoleUpdate(original, current);
        }
    }

    class ServiceAccountUpdater
    extends ResourceManager.ResourceUpdater<V1ServiceAccount> {
        ServiceAccountUpdater(V1ServiceAccount serviceAccount) {
            super(serviceAccount);
        }

        @Override
        V1ServiceAccount getCurrentResource() {
            V1ServiceAccount result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.readNamespacedServiceAccount(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1ServiceAccount applyResource(V1ServiceAccount original, V1ServiceAccount current) {
            V1ServiceAccount result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedServiceAccount(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1ServiceAccount createResource(V1ServiceAccount current) {
            V1ServiceAccount result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.createNamespacedServiceAccount(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1ServiceAccount current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedServiceAccount(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1ServiceAccount original, V1ServiceAccount current) {
            V1ResourceManager.this.resourceUpdateMonitor.onServiceAccountUpdate(original, current);
        }
    }

    class RoleBindingUpdater
    extends ResourceManager.ResourceUpdater<V1RoleBinding> {
        RoleBindingUpdater(V1RoleBinding roleBinding) {
            super(roleBinding);
        }

        @Override
        V1RoleBinding getCurrentResource() {
            V1RoleBinding result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.readNamespacedRoleBinding(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty());
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1RoleBinding applyResource(V1RoleBinding original, V1RoleBinding current) {
            V1RoleBinding result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.replaceNamespacedRoleBinding(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1RoleBinding createResource(V1RoleBinding current) {
            V1RoleBinding result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.createNamespacedRoleBinding(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1RoleBinding current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.deleteNamespacedRoleBinding(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1RoleBinding original, V1RoleBinding current) {
            V1ResourceManager.this.resourceUpdateMonitor.onRoleBindingUpdate(original, current);
        }
    }

    class RoleUpdater
    extends ResourceManager.ResourceUpdater<V1Role> {
        RoleUpdater(V1Role role) {
            super(role);
        }

        @Override
        V1Role getCurrentResource() {
            V1Role result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.readNamespacedRole(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty());
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1Role applyResource(V1Role original, V1Role current) {
            V1Role result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.replaceNamespacedRole(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Role createResource(V1Role current) {
            V1Role result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.createNamespacedRole(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1Role current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.rbacV1Api.deleteNamespacedRole(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Role original, V1Role current) {
            V1ResourceManager.this.resourceUpdateMonitor.onRoleUpdate(original, current);
        }
    }

    class NetworkPolicyUpdater
    extends ResourceManager.ResourceUpdater<V1NetworkPolicy> {
        NetworkPolicyUpdater(V1NetworkPolicy networkPolicy) {
            super(networkPolicy);
        }

        @Override
        V1NetworkPolicy getCurrentResource() {
            V1NetworkPolicy result = null;
            try {
                result = V1ResourceManager.this.networkingV1Api.readNamespacedNetworkPolicy(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1NetworkPolicy applyResource(V1NetworkPolicy original, V1NetworkPolicy current) {
            V1NetworkPolicy result = null;
            try {
                result = V1ResourceManager.this.networkingV1Api.replaceNamespacedNetworkPolicy(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1NetworkPolicy createResource(V1NetworkPolicy current) {
            V1NetworkPolicy result = null;
            try {
                result = V1ResourceManager.this.networkingV1Api.createNamespacedNetworkPolicy(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1NetworkPolicy current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.networkingV1Api.deleteNamespacedNetworkPolicy(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1NetworkPolicy original, V1NetworkPolicy current) {
            V1ResourceManager.this.resourceUpdateMonitor.onNetworkPolicyUpdate(original, current);
        }
    }

    class PersistentVolumeUpdater
    extends ResourceManager.ResourceUpdater<V1PersistentVolume> {
        PersistentVolumeUpdater(V1PersistentVolume persistentVolume) {
            super(persistentVolume);
        }

        @Override
        V1PersistentVolume getCurrentResource() {
            V1PersistentVolume result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.readPersistentVolume(this.getName(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1PersistentVolume applyResource(V1PersistentVolume original, V1PersistentVolume current) {
            V1PersistentVolume result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.replacePersistentVolume(this.getName(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1PersistentVolume createResource(V1PersistentVolume current) {
            V1PersistentVolume result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.createPersistentVolume(current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1PersistentVolume current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deletePersistentVolume(this.getName(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1PersistentVolume original, V1PersistentVolume current) {
            V1ResourceManager.this.resourceUpdateMonitor.onPersistentVolumeUpdate(original, current);
        }
    }

    class PersistentVolumeClaimUpdater
    extends ResourceManager.ResourceUpdater<V1PersistentVolumeClaim> {
        PersistentVolumeClaimUpdater(V1PersistentVolumeClaim namespace) {
            super(namespace);
        }

        @Override
        V1PersistentVolumeClaim getCurrentResource() {
            V1PersistentVolumeClaim result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.readNamespacedPersistentVolumeClaim(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1PersistentVolumeClaim applyResource(V1PersistentVolumeClaim original, V1PersistentVolumeClaim current) {
            if (current.getSpec() != null && original.getSpec() != null) {
                if (current.getSpec().getStorageClassName() == null) {
                    current.getSpec().setStorageClassName(original.getSpec().getStorageClassName());
                }
                if (current.getSpec().getVolumeName() == null) {
                    current.getSpec().setVolumeName(original.getSpec().getVolumeName());
                }
                if (current.getSpec().getVolumeMode() == null) {
                    current.getSpec().setVolumeMode(original.getSpec().getVolumeMode());
                }
                if (current.getSpec().getResources() == null) {
                    current.getSpec().setResources(original.getSpec().getResources());
                }
            }
            V1PersistentVolumeClaim result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedPersistentVolumeClaim(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1PersistentVolumeClaim createResource(V1PersistentVolumeClaim current) {
            V1PersistentVolumeClaim result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.createNamespacedPersistentVolumeClaim(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1PersistentVolumeClaim current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedPersistentVolumeClaim(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1PersistentVolumeClaim original, V1PersistentVolumeClaim current) {
            V1ResourceManager.this.resourceUpdateMonitor.onPersistentVolumeClaimUpdate(original, current);
        }
    }

    class StatefulSetUpdater
    extends ResourceManager.ResourceUpdater<V1StatefulSet> {
        StatefulSetUpdater(V1StatefulSet namespace) {
            super(namespace);
        }

        @Override
        V1StatefulSet getCurrentResource() {
            V1StatefulSet result = null;
            try {
                result = V1ResourceManager.this.appsV1ApiInstance.readNamespacedStatefulSet(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1StatefulSet applyResource(V1StatefulSet original, V1StatefulSet current) {
            V1StatefulSet result = null;
            try {
                V1StatefulSet putStatefulSet = this.getPutObject(original, current);
                result = V1ResourceManager.this.appsV1ApiInstance.replaceNamespacedStatefulSet(this.getName(), this.getNamespace(), putStatefulSet, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1StatefulSet createResource(V1StatefulSet current) {
            V1StatefulSet result = null;
            try {
                result = V1ResourceManager.this.appsV1ApiInstance.createNamespacedStatefulSet(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1StatefulSet current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.appsV1ApiInstance.deleteNamespacedStatefulSet(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        V1StatefulSet getPutObject(V1StatefulSet original, V1StatefulSet current) {
            V1StatefulSet dryRunReq = (V1StatefulSet)KubernetesJsonUtils.getKubernetesJson().deserialize(KubernetesJsonUtils.getKubernetesJson().serialize((Object)current), V1StatefulSet.class);
            V1StatefulSet dryRunRes = null;
            dryRunReq.getMetadata().setName(null);
            dryRunReq.getMetadata().setGenerateName(this.getName());
            dryRunReq.getMetadata().setNamespace(this.getNamespace());
            try {
                dryRunRes = V1ResourceManager.this.appsV1ApiInstance.createNamespacedStatefulSet(dryRunReq.getMetadata().getNamespace(), dryRunReq, V1ResourceManager.this.getPretty(), "All", null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            Preconditions.checkNotNull(dryRunRes);
            dryRunRes.getMetadata().name(this.getName()).creationTimestamp(original.getMetadata().getCreationTimestamp()).selfLink(original.getMetadata().getSelfLink()).uid(original.getMetadata().getUid()).resourceVersion(original.getMetadata().getUid()).ownerReferences(original.getMetadata().getOwnerReferences()).generateName(null);
            V1ResourceManager.recoverPodImagePullPolicy(original.getSpec().getTemplate().getSpec(), current.getSpec().getTemplate().getSpec(), dryRunRes.getSpec().getTemplate().getSpec());
            return dryRunRes;
        }

        @Override
        void notifyUpdate(V1StatefulSet original, V1StatefulSet current) {
            V1ResourceManager.this.resourceUpdateMonitor.onStatefulSetUpdate(original, current);
        }
    }

    class HorizontalPodAutoscalerUpdater
    extends ResourceManager.ResourceUpdater<V1HorizontalPodAutoscaler> {
        HorizontalPodAutoscalerUpdater(V1HorizontalPodAutoscaler namespace) {
            super(namespace);
        }

        @Override
        V1HorizontalPodAutoscaler getCurrentResource() {
            V1HorizontalPodAutoscaler result = null;
            try {
                result = V1ResourceManager.this.autoscalingV1Api.readNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1HorizontalPodAutoscaler applyResource(V1HorizontalPodAutoscaler original, V1HorizontalPodAutoscaler current) {
            V1HorizontalPodAutoscaler result = null;
            try {
                result = V1ResourceManager.this.autoscalingV1Api.replaceNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1HorizontalPodAutoscaler createResource(V1HorizontalPodAutoscaler current) {
            V1HorizontalPodAutoscaler result = null;
            try {
                result = V1ResourceManager.this.autoscalingV1Api.createNamespacedHorizontalPodAutoscaler(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1HorizontalPodAutoscaler current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.autoscalingV1Api.deleteNamespacedHorizontalPodAutoscaler(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1HorizontalPodAutoscaler original, V1HorizontalPodAutoscaler current) {
            V1ResourceManager.this.resourceUpdateMonitor.onHorizontalPodAutoscalerUpdate(original, current);
        }
    }

    class NamespaceUpdater
    extends ResourceManager.ResourceUpdater<V1Namespace> {
        NamespaceUpdater(V1Namespace namespace) {
            super(namespace);
        }

        @Override
        V1Namespace getCurrentResource() {
            V1Namespace result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.readNamespace(this.getName(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1Namespace applyResource(V1Namespace original, V1Namespace current) {
            V1Namespace result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.replaceNamespace(this.getName(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Namespace createResource(V1Namespace current) {
            V1Namespace result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.createNamespace(current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1Namespace current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespace(this.getName(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Namespace original, V1Namespace current) {
            V1ResourceManager.this.resourceUpdateMonitor.onNamespaceUpdate(original, current);
        }
    }

    class SecretUpdater
    extends ResourceManager.ResourceUpdater<V1Secret> {
        SecretUpdater(V1Secret secret) {
            super(secret);
        }

        @Override
        V1Secret getCurrentResource() {
            V1Secret secret = null;
            try {
                secret = V1ResourceManager.this.coreV1ApiInstance.readNamespacedSecret(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return secret;
        }

        @Override
        V1Secret applyResource(V1Secret original, V1Secret current) {
            V1Secret secret = null;
            try {
                secret = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedSecret(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return secret;
        }

        @Override
        V1Secret createResource(V1Secret current) {
            V1Secret secret = null;
            try {
                secret = V1ResourceManager.this.coreV1ApiInstance.createNamespacedSecret(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return secret;
        }

        @Override
        V1Status deleteResource(V1Secret current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedSecret(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Secret original, V1Secret current) {
            V1ResourceManager.this.resourceUpdateMonitor.onSecretUpdate(original, current);
        }

        @Override
        void logApplied(V1Secret res) {
            V1ResourceManager.this.getConsoleLogger().println(Messages.KubernetesClientWrapper_applied("Secret", "name: " + this.getName()));
        }

        @Override
        void logCreated(V1Secret res) {
            V1ResourceManager.this.getConsoleLogger().println(Messages.KubernetesClientWrapper_created(this.getKind(), "name: " + this.getName()));
        }
    }

    class ConfigMapUpdater
    extends ResourceManager.ResourceUpdater<V1ConfigMap> {
        ConfigMapUpdater(V1ConfigMap configMap) {
            super(configMap);
        }

        @Override
        V1ConfigMap getCurrentResource() {
            V1ConfigMap configMap = null;
            try {
                configMap = V1ResourceManager.this.coreV1ApiInstance.readNamespacedConfigMap(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return configMap;
        }

        @Override
        V1ConfigMap applyResource(V1ConfigMap original, V1ConfigMap current) {
            V1ConfigMap configMap = null;
            try {
                configMap = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedConfigMap(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return configMap;
        }

        @Override
        V1ConfigMap createResource(V1ConfigMap current) {
            V1ConfigMap configMap = null;
            try {
                configMap = V1ResourceManager.this.coreV1ApiInstance.createNamespacedConfigMap(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return configMap;
        }

        @Override
        V1Status deleteResource(V1ConfigMap current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedConfigMap(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1ConfigMap original, V1ConfigMap current) {
            V1ResourceManager.this.resourceUpdateMonitor.onConfigMapUpdate(original, current);
        }
    }

    class PodUpdater
    extends ResourceManager.ResourceUpdater<V1Pod> {
        PodUpdater(V1Pod pod) {
            super(pod);
        }

        @Override
        V1Pod getCurrentResource() {
            V1Pod pod = null;
            try {
                pod = V1ResourceManager.this.coreV1ApiInstance.readNamespacedPod(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return pod;
        }

        @Override
        V1Pod applyResource(V1Pod original, V1Pod current) {
            V1Pod pod = null;
            V1Pod putPod = this.getPutObject(original, current);
            try {
                pod = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedPod(this.getName(), this.getNamespace(), putPod, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return pod;
        }

        V1Pod getPutObject(V1Pod original, V1Pod current) {
            V1Pod dryRunReq = (V1Pod)KubernetesJsonUtils.getKubernetesJson().deserialize(KubernetesJsonUtils.getKubernetesJson().serialize((Object)current), V1Pod.class);
            V1Pod dryRunRes = null;
            dryRunReq.getMetadata().setName(null);
            dryRunReq.getMetadata().setGenerateName(this.getName());
            dryRunReq.getMetadata().setNamespace(this.getNamespace());
            try {
                dryRunRes = V1ResourceManager.this.coreV1ApiInstance.createNamespacedPod(dryRunReq.getMetadata().getNamespace(), dryRunReq, V1ResourceManager.this.getPretty(), "All", null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            Preconditions.checkNotNull(dryRunRes);
            dryRunRes.getMetadata().name(this.getName()).creationTimestamp(original.getMetadata().getCreationTimestamp()).selfLink(original.getMetadata().getSelfLink()).uid(original.getMetadata().getUid()).resourceVersion(original.getMetadata().getUid()).ownerReferences(original.getMetadata().getOwnerReferences()).generateName(null);
            dryRunRes.getSpec().nodeName(original.getSpec().getNodeName());
            V1ResourceManager.recoverPodImagePullPolicy(original.getSpec(), current.getSpec(), dryRunRes.getSpec());
            return dryRunRes;
        }

        @Override
        V1Pod createResource(V1Pod current) {
            V1Pod pod = null;
            try {
                pod = V1ResourceManager.this.coreV1ApiInstance.createNamespacedPod(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return pod;
        }

        @Override
        V1Status deleteResource(V1Pod current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedPod(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Pod original, V1Pod current) {
            V1ResourceManager.this.resourceUpdateMonitor.onPodUpdate(original, current);
        }
    }

    class JobUpdater
    extends ResourceManager.ResourceUpdater<V1Job> {
        JobUpdater(V1Job job) {
            super(job);
        }

        @Override
        V1Job getCurrentResource() {
            V1Job job = null;
            try {
                job = V1ResourceManager.this.batchV1ApiInstance.readNamespacedJob(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return job;
        }

        @Override
        V1Job applyResource(V1Job original, V1Job current) {
            V1Job job = null;
            V1Job putJob = this.getPutObject(original, current);
            try {
                job = V1ResourceManager.this.batchV1ApiInstance.replaceNamespacedJob(this.getName(), this.getNamespace(), putJob, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return job;
        }

        V1Job getPutObject(V1Job original, V1Job current) {
            V1Job dryRunReq = (V1Job)KubernetesJsonUtils.getKubernetesJson().deserialize(KubernetesJsonUtils.getKubernetesJson().serialize((Object)current), V1Job.class);
            V1Job dryRunRes = null;
            dryRunReq.getMetadata().setName(null);
            dryRunReq.getMetadata().setGenerateName(this.getName());
            dryRunReq.getMetadata().setNamespace(this.getNamespace());
            try {
                dryRunRes = V1ResourceManager.this.batchV1ApiInstance.createNamespacedJob(dryRunReq.getMetadata().getNamespace(), dryRunReq, V1ResourceManager.this.getPretty(), "All", null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            Preconditions.checkNotNull(dryRunRes);
            dryRunRes.getMetadata().name(this.getName()).creationTimestamp(original.getMetadata().getCreationTimestamp()).selfLink(original.getMetadata().getSelfLink()).uid(original.getMetadata().getUid()).resourceVersion(original.getMetadata().getUid()).ownerReferences(original.getMetadata().getOwnerReferences()).generateName(null);
            if (BooleanUtils.isNotTrue((Boolean)current.getSpec().getManualSelector())) {
                String controllerUid = (String)original.getMetadata().getLabels().get("controller-uid");
                dryRunRes.getMetadata().getLabels().put("controller-uid", controllerUid);
                dryRunRes.getMetadata().getLabels().put("job-name", this.getName());
                dryRunRes.getSpec().getSelector().putMatchLabelsItem("controller-uid", controllerUid);
                dryRunRes.getSpec().getTemplate().getMetadata().getLabels().put("controller-uid", controllerUid);
                dryRunRes.getSpec().getTemplate().getMetadata().getLabels().put("job-name", this.getName());
            }
            V1ResourceManager.recoverPodImagePullPolicy(original.getSpec().getTemplate().getSpec(), current.getSpec().getTemplate().getSpec(), dryRunRes.getSpec().getTemplate().getSpec());
            return dryRunRes;
        }

        @Override
        V1Job createResource(V1Job current) {
            V1Job job = null;
            try {
                job = V1ResourceManager.this.batchV1ApiInstance.createNamespacedJob(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return job;
        }

        @Override
        V1Status deleteResource(V1Job current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.batchV1ApiInstance.deleteNamespacedJob(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Job original, V1Job current) {
            V1ResourceManager.this.resourceUpdateMonitor.onJobUpdate(original, current);
        }
    }

    class ServiceUpdater
    extends ResourceManager.ResourceUpdater<V1Service> {
        ServiceUpdater(V1Service service) {
            super(service);
        }

        @Override
        V1Service getCurrentResource() {
            V1Service service = null;
            try {
                service = V1ResourceManager.this.coreV1ApiInstance.readNamespacedService(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return service;
        }

        @Override
        V1Service applyResource(V1Service original, V1Service current) {
            List originalPorts = original.getSpec().getPorts();
            List currentPorts = current.getSpec().getPorts();
            if (originalPorts != null && currentPorts != null) {
                HashMap<Integer, Integer> portToNodePort = new HashMap<Integer, Integer>();
                for (V1ServicePort servicePort : originalPorts) {
                    Integer port = servicePort.getPort();
                    Integer nodePort = servicePort.getNodePort();
                    if (port == null || nodePort == null) continue;
                    portToNodePort.put(servicePort.getPort(), servicePort.getNodePort());
                }
                for (V1ServicePort servicePort : currentPorts) {
                    Integer nodePort;
                    Integer port;
                    Integer currentNodePort = servicePort.getNodePort();
                    if (currentNodePort != null && currentNodePort != 0 || (port = servicePort.getPort()) == null || (nodePort = (Integer)portToNodePort.get(port)) == null) continue;
                    servicePort.setNodePort(nodePort);
                }
            }
            current.getSpec().setPorts(currentPorts);
            current.getMetadata().setResourceVersion(original.getMetadata().getResourceVersion());
            if (StringUtils.isBlank((CharSequence)current.getSpec().getClusterIP())) {
                current.getSpec().setClusterIP(original.getSpec().getClusterIP());
            }
            V1Service service = null;
            try {
                service = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedService(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return service;
        }

        @Override
        V1Service createResource(V1Service current) {
            V1Service service = null;
            try {
                service = V1ResourceManager.this.coreV1ApiInstance.createNamespacedService(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return service;
        }

        @Override
        V1Status deleteResource(V1Service current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedService(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Service original, V1Service current) {
            V1ResourceManager.this.resourceUpdateMonitor.onServiceUpdate(original, current);
        }
    }

    class ReplicationControllerUpdater
    extends ResourceManager.ResourceUpdater<V1ReplicationController> {
        ReplicationControllerUpdater(V1ReplicationController rc) {
            super(rc);
        }

        @Override
        V1ReplicationController getCurrentResource() {
            V1ReplicationController replicationController = null;
            try {
                replicationController = V1ResourceManager.this.coreV1ApiInstance.readNamespacedReplicationController(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return replicationController;
        }

        @Override
        V1ReplicationController applyResource(V1ReplicationController original, V1ReplicationController current) {
            V1ReplicationController replicationController = null;
            try {
                replicationController = V1ResourceManager.this.coreV1ApiInstance.replaceNamespacedReplicationController(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return replicationController;
        }

        @Override
        V1ReplicationController createResource(V1ReplicationController current) {
            V1ReplicationController replicationController = null;
            try {
                replicationController = V1ResourceManager.this.coreV1ApiInstance.createNamespacedReplicationController(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return replicationController;
        }

        @Override
        V1Status deleteResource(V1ReplicationController current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.coreV1ApiInstance.deleteNamespacedReplicationController(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1ReplicationController original, V1ReplicationController current) {
            V1ResourceManager.this.resourceUpdateMonitor.onReplicationControllerUpdate(original, current);
        }
    }

    class DaemonSetUpdater
    extends ResourceManager.ResourceUpdater<V1DaemonSet> {
        DaemonSetUpdater(V1DaemonSet ds) {
            super(ds);
        }

        @Override
        V1DaemonSet getCurrentResource() {
            V1DaemonSet daemonSet = null;
            try {
                daemonSet = V1ResourceManager.this.appsV1ApiInstance.readNamespacedDaemonSet(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return daemonSet;
        }

        @Override
        V1DaemonSet applyResource(V1DaemonSet original, V1DaemonSet current) {
            V1DaemonSet daemonSet = null;
            try {
                daemonSet = V1ResourceManager.this.appsV1ApiInstance.replaceNamespacedDaemonSet(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return daemonSet;
        }

        @Override
        V1DaemonSet createResource(V1DaemonSet current) {
            V1DaemonSet daemonSet = null;
            try {
                daemonSet = V1ResourceManager.this.appsV1ApiInstance.createNamespacedDaemonSet(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return daemonSet;
        }

        @Override
        V1Status deleteResource(V1DaemonSet current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.appsV1ApiInstance.deleteNamespacedDaemonSet(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1DaemonSet original, V1DaemonSet current) {
            V1ResourceManager.this.resourceUpdateMonitor.onDaemonSetUpdate(original, current);
        }
    }

    class DeploymentUpdater
    extends ResourceManager.ResourceUpdater<V1Deployment> {
        DeploymentUpdater(V1Deployment deployment) {
            super(deployment);
        }

        @Override
        V1Deployment getCurrentResource() {
            V1Deployment deployment = null;
            try {
                deployment = V1ResourceManager.this.appsV1ApiInstance.readNamespacedDeployment(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return deployment;
        }

        @Override
        V1Deployment applyResource(V1Deployment original, V1Deployment current) {
            V1Deployment deployment = null;
            try {
                deployment = V1ResourceManager.this.appsV1ApiInstance.replaceNamespacedDeployment(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        V1Deployment createResource(V1Deployment current) {
            V1Deployment deployment = null;
            try {
                deployment = V1ResourceManager.this.appsV1ApiInstance.createNamespacedDeployment(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        V1Status deleteResource(V1Deployment current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.appsV1ApiInstance.deleteNamespacedDeployment(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1Deployment original, V1Deployment current) {
            V1ResourceManager.this.resourceUpdateMonitor.onDeploymentUpdate(original, current);
        }
    }

    class ReplicaSetUpdater
    extends ResourceManager.ResourceUpdater<V1ReplicaSet> {
        ReplicaSetUpdater(V1ReplicaSet rs) {
            super(rs);
        }

        @Override
        V1ReplicaSet getCurrentResource() {
            V1ReplicaSet replicaSet = null;
            try {
                replicaSet = V1ResourceManager.this.appsV1ApiInstance.readNamespacedReplicaSet(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return replicaSet;
        }

        @Override
        V1ReplicaSet applyResource(V1ReplicaSet original, V1ReplicaSet current) {
            V1ReplicaSet replicaSet = null;
            try {
                replicaSet = V1ResourceManager.this.appsV1ApiInstance.replaceNamespacedReplicaSet(this.getName(), this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return replicaSet;
        }

        @Override
        V1ReplicaSet createResource(V1ReplicaSet current) {
            V1ReplicaSet replicaSet = null;
            try {
                replicaSet = V1ResourceManager.this.appsV1ApiInstance.createNamespacedReplicaSet(this.getNamespace(), current, V1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiException(e);
            }
            return replicaSet;
        }

        @Override
        V1Status deleteResource(V1ReplicaSet current) {
            V1Status result = null;
            try {
                result = V1ResourceManager.this.appsV1ApiInstance.deleteNamespacedReplicaSet(this.getName(), this.getNamespace(), V1ResourceManager.this.getPretty(), null, null, null, null, null);
            }
            catch (ApiException e) {
                V1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1ReplicaSet original, V1ReplicaSet current) {
            V1ResourceManager.this.resourceUpdateMonitor.onReplicaSetUpdate(original, current);
        }
    }
}

