/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import hudson.FilePath;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;

public class DockerConfigBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<ResolvedDockerRegistryEndpoint> endpoints;

    public DockerConfigBuilder(List<ResolvedDockerRegistryEndpoint> credentials) {
        this.endpoints = credentials;
    }

    public FilePath buildArchive(FilePath workspace) throws IOException, InterruptedException {
        FilePath outputFile = workspace.createTempFile("docker", ".tar.gz");
        try (TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(outputFile.write()));){
            ObjectNode auths = this.buildAuthsObject();
            JsonNode config = MAPPER.createObjectNode().set("auths", (JsonNode)auths);
            byte[] bytes = config.toString().getBytes("UTF-8");
            TarArchiveEntry entry = new TarArchiveEntry(".docker/config.json");
            entry.setSize((long)bytes.length);
            out.putArchiveEntry((ArchiveEntry)entry);
            out.write(bytes);
            out.closeArchiveEntry();
        }
        return outputFile;
    }

    public String buildDockercfgBase64() throws IOException {
        return Base64.encodeBase64String((byte[])this.buildDockercfgString().getBytes("UTF-8"));
    }

    public String buildDockercfgString() throws IOException {
        ObjectNode auths = this.buildAuthsObject();
        return auths.toString();
    }

    public ObjectNode buildAuthsObject() throws IOException {
        ObjectNode auths = MAPPER.createObjectNode();
        for (ResolvedDockerRegistryEndpoint endpoint : this.endpoints) {
            DockerRegistryToken token = endpoint.getToken();
            ObjectNode entry = MAPPER.createObjectNode().put("email", token.getEmail()).put("auth", token.getToken());
            auths.set(endpoint.getUrl().toString(), (JsonNode)entry);
        }
        return auths;
    }
}

