/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.util;

import com.microsoft.jenkins.kubernetes.Messages;
import hudson.Util;
import hudson.util.VariableResolver;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public final class CommonUtils {
    private static final char[] DIGITS;
    private static final char[] DIGITS_ASCII_LOWERCASE;
    private static final char[] DIGITS_ASCII_LETTERS;
    private static final ThreadLocal<Random> THREAD_LOCAL_RANDOM;

    public static InputStream replaceMacro(InputStream original, VariableResolver<String> variableResolver) throws IOException {
        if (variableResolver == null) {
            return original;
        }
        try {
            String content = IOUtils.toString((InputStream)original, (String)"UTF-8");
            content = Util.replaceMacro((String)content, variableResolver);
            if (content != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
                return byteArrayInputStream;
            }
            throw new IllegalArgumentException(Messages.JobContext_nullContent());
        }
        finally {
            original.close();
        }
    }

    public static Random threadLocalRandom() {
        return THREAD_LOCAL_RANDOM.get();
    }

    public static String randomString() {
        int defaultLength = 16;
        return CommonUtils.randomString(16, false, false);
    }

    public static String randomString(int length) {
        return CommonUtils.randomString(length, false, false);
    }

    public static String randomString(int length, boolean forceLowercase) {
        return CommonUtils.randomString(length, forceLowercase, false);
    }

    public static String randomString(int length, boolean forceLowercase, boolean digitsOnly) {
        char[] pool = DIGITS;
        if (!digitsOnly) {
            pool = forceLowercase ? DIGITS_ASCII_LOWERCASE : DIGITS_ASCII_LETTERS;
        }
        char[] sample = new char[length];
        Random rand = CommonUtils.threadLocalRandom();
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = pool[rand.nextInt(pool.length)];
        }
        return new String(sample);
    }

    public static String getResourceName(Object object) {
        String name = null;
        try {
            Method method = object.getClass().getMethod("getMetadata", new Class[0]);
            V1ObjectMeta metadata = (V1ObjectMeta)method.invoke(object, new Object[0]);
            name = metadata.getName();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return name;
    }

    private CommonUtils() {
    }

    static {
        THREAD_LOCAL_RANDOM = new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                return new Random();
            }
        };
        String digits = "0123456789";
        String asciiLowercase = "abcdefghijklmnopqrstuvwxyz";
        DIGITS = digits.toCharArray();
        DIGITS_ASCII_LOWERCASE = (digits + asciiLowercase).toCharArray();
        DIGITS_ASCII_LETTERS = (digits + asciiLowercase + asciiLowercase.toUpperCase()).toCharArray();
    }
}

