/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.credentials;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.microsoft.jenkins.azurecommons.remote.SSHClient;
import com.microsoft.jenkins.kubernetes.Messages;
import com.microsoft.jenkins.kubernetes.credentials.ClientWrapperFactory;
import com.microsoft.jenkins.kubernetes.wrapper.KubernetesClientWrapper;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.OutputStream;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Deprecated
public class SSHCredentials
extends AbstractDescribableImpl<SSHCredentials>
implements ClientWrapperFactory.Builder {
    private String sshServer;
    private String sshCredentialsId;

    @DataBoundConstructor
    public SSHCredentials() {
    }

    public String getSshServer() {
        return this.sshServer;
    }

    @DataBoundSetter
    public void setSshServer(String sshServer) {
        this.sshServer = StringUtils.trimToEmpty((String)sshServer);
    }

    public String getSshCredentialsId() {
        return this.sshCredentialsId;
    }

    @DataBoundSetter
    public void setSshCredentialsId(String sshCredentialsId) {
        this.sshCredentialsId = sshCredentialsId;
    }

    @Nonnull
    public StandardUsernameCredentials getSshCredentials(Item owner) {
        StandardUsernameCredentials creds = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.getSshCredentialsId()));
        if (creds == null) {
            throw new IllegalStateException("Cannot find SSH credentials with ID " + this.getSshCredentialsId());
        }
        return creds;
    }

    public String getHost() {
        int colonIndex = this.sshServer.lastIndexOf(58);
        if (colonIndex >= 0) {
            return this.sshServer.substring(0, colonIndex);
        }
        return this.sshServer;
    }

    public int getPort() {
        int colonIndex = this.sshServer.indexOf(58);
        if (colonIndex >= 0) {
            return Integer.parseInt(this.sshServer.substring(colonIndex + 1));
        }
        return 22;
    }

    @Override
    public ClientWrapperFactory buildClientWrapperFactory(Item owner) {
        return new ClientWrapperFactoryImpl(this.getHost(), this.getPort(), this.getSshCredentials(owner));
    }

    private static class ClientWrapperFactoryImpl
    implements ClientWrapperFactory {
        private static final long serialVersionUID = 1L;
        private final String host;
        private final int port;
        private final StandardUsernameCredentials credentials;

        ClientWrapperFactoryImpl(String host, int port, StandardUsernameCredentials credentials) {
            this.host = host;
            this.port = port;
            this.credentials = credentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KubernetesClientWrapper buildClient(FilePath workspace) throws Exception {
            FilePath kubeconfig = this.fetchConfig(workspace);
            try {
                KubernetesClientWrapper kubernetesClientWrapper = new KubernetesClientWrapper(kubeconfig.getRemote());
                return kubernetesClientWrapper;
            }
            finally {
                kubeconfig.delete();
            }
        }

        private FilePath fetchConfig(FilePath workspace) throws Exception {
            SSHClient sshClient = new SSHClient(this.host, this.port, this.credentials);
            try (SSHClient ignore = sshClient.connect();){
                FilePath configFile = workspace.createTempFile("kubeconfig-", "");
                try (OutputStream out = configFile.write();){
                    sshClient.copyFrom(".kube/config", out);
                }
                FilePath filePath = configFile;
                return filePath;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SSHCredentials> {
        public ListBoxModel doFillSshCredentialsIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel model = new StandardListBoxModel();
            model.add(Messages.SSHCredentials_selectCredentials(), "*");
            model.includeAs(ACL.SYSTEM, owner, SSHUserPrivateKey.class);
            model.includeAs(ACL.SYSTEM, owner, StandardUsernamePasswordCredentials.class);
            return model;
        }

        public FormValidation doCheckSshServer(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)Messages.SSHCredentials_serverRequired());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSshCredentialsId(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value) || "*".equals(value)) {
                return FormValidation.error((String)Messages.SSHCredentials_credentialsIdRequired());
            }
            return FormValidation.ok();
        }
    }
}

