/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.credentials;

import com.microsoft.jenkins.kubernetes.credentials.KubeconfigCredentials;
import hudson.Extension;
import hudson.FilePath;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.impl.AbstractOnDiskBinding;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubeconfigFileCredentialsBinding
extends AbstractOnDiskBinding<KubeconfigCredentials> {
    public static final int FILE_MASK = 256;
    private static final String DEFAULT_VARIABLE_NAME = "KUBECONFIG";

    @DataBoundConstructor
    public KubeconfigFileCredentialsBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    protected FilePath write(KubeconfigCredentials credentials, FilePath dir) throws IOException, InterruptedException {
        FilePath secret = dir.child("kubeconfig");
        String content = credentials.getContent();
        secret.write(content, StandardCharsets.UTF_8.name());
        secret.chmod(256);
        return secret;
    }

    protected Class<KubeconfigCredentials> type() {
        return KubeconfigCredentials.class;
    }

    @Symbol(value={"kubeconfigFile"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<KubeconfigCredentials> {
        protected Class<KubeconfigCredentials> type() {
            return KubeconfigCredentials.class;
        }

        @Nonnull
        public String getDisplayName() {
            return "Kubeconfig File";
        }

        public String getDefaultVariableName() {
            return KubeconfigFileCredentialsBinding.DEFAULT_VARIABLE_NAME;
        }
    }
}

