/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.credentials;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.microsoft.jenkins.kubernetes.credentials.KubeconfigCredentials;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.Binding;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubeconfigCredentialsBinding
extends Binding {
    public static final String DEFAULT_VARIABLE_NAME = "KUBECONFIG_CONTENT";

    @DataBoundConstructor
    public KubeconfigCredentialsBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    protected Class type() {
        return KubeconfigCredentials.class;
    }

    public Binding.SingleEnvironment bindSingle(@Nonnull Run build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        KubeconfigCredentials credentials = (KubeconfigCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(KubeconfigCredentials.class, (Item)build.getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.getCredentialsId()));
        if (credentials == null) {
            throw new IllegalStateException("Cannot find kubeconfig credentials with ID '" + this.getCredentialsId() + "'");
        }
        credentials.bindToAncestor((Item)build.getParent());
        return new Binding.SingleEnvironment(credentials.getContent());
    }

    @Extension
    @Symbol(value={"kubeconfigContent"})
    public static class DescriptorImpl
    extends BindingDescriptor<KubeconfigCredentials> {
        protected Class<KubeconfigCredentials> type() {
            return KubeconfigCredentials.class;
        }

        @Nonnull
        public String getDisplayName() {
            return "Kubeconfig Content";
        }

        public boolean requiresWorkspace() {
            return false;
        }

        public String getDefaultVariableName() {
            return KubeconfigCredentialsBinding.DEFAULT_VARIABLE_NAME;
        }
    }
}

