/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.microsoft.jenkins.kubernetes.credentials.AncestorAware;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.remoting.Channel;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KubeconfigCredentials
extends BaseStandardCredentials
implements AncestorAware {
    private static final long serialVersionUID = 1L;
    private final KubeconfigSource kubeconfigSource;
    private transient Item owner;

    @DataBoundConstructor
    public KubeconfigCredentials(CredentialsScope scope, String id, String description, KubeconfigSource kubeconfigSource) {
        super(scope, id, description);
        this.kubeconfigSource = kubeconfigSource;
    }

    public KubeconfigSource getKubeconfigSource() {
        return this.kubeconfigSource;
    }

    public String getContent() {
        if (this.kubeconfigSource != null) {
            if (this.kubeconfigSource instanceof AncestorAware) {
                ((AncestorAware)((Object)this.kubeconfigSource)).bindToAncestor(this.owner);
            }
            return this.kubeconfigSource.getContent();
        }
        return "";
    }

    @Override
    public void bindToAncestor(Item o) {
        this.owner = o;
    }

    private Object writeReplace() {
        if (Channel.current() == null) {
            return this;
        }
        if (this.kubeconfigSource == null || this.kubeconfigSource.isSnapshotSource()) {
            return this;
        }
        return CredentialsProvider.snapshot((Credentials)this);
    }

    @Extension
    public static class CredentialsSnapshotTakerImpl
    extends CredentialsSnapshotTaker<KubeconfigCredentials> {
        public Class<KubeconfigCredentials> type() {
            return KubeconfigCredentials.class;
        }

        public KubeconfigCredentials snapshot(KubeconfigCredentials credentials) {
            KubeconfigSource source = credentials.getKubeconfigSource();
            if (source.isSnapshotSource()) {
                return credentials;
            }
            return new KubeconfigCredentials(credentials.getScope(), credentials.getId(), credentials.getDescription(), new DirectEntryKubeconfigSource(credentials.getContent()));
        }
    }

    public static class FileOnKubernetesMasterKubeconfigSource
    extends KubeconfigSource
    implements AncestorAware {
        private final String server;
        private final String sshCredentialId;
        private String file;
        private transient Item owner;

        @DataBoundConstructor
        public FileOnKubernetesMasterKubeconfigSource(String server, String sshCredentialId) {
            this.server = server;
            this.sshCredentialId = sshCredentialId;
        }

        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)super.getDescriptor();
        }

        public String getServer() {
            return this.server;
        }

        public String getHost() {
            String serverName = this.getServer();
            if (StringUtils.isBlank((String)serverName)) {
                return null;
            }
            int colonIndex = serverName.lastIndexOf(58);
            if (colonIndex >= 0) {
                return serverName.substring(0, colonIndex);
            }
            return serverName;
        }

        public int getPort() {
            String serverName = this.getServer();
            if (StringUtils.isBlank((String)serverName)) {
                return 22;
            }
            int colonIndex = serverName.indexOf(58);
            if (colonIndex >= 0) {
                return Integer.parseInt(serverName.substring(colonIndex + 1));
            }
            return 22;
        }

        public String getSshCredentialId() {
            return this.sshCredentialId;
        }

        public String getFile() {
            if (StringUtils.isBlank((String)this.file)) {
                return this.getDescriptor().getDefaultFile();
            }
            return this.file;
        }

        @DataBoundSetter
        public void setFile(String file) {
            this.file = StringUtils.isBlank((String)file) || this.getDescriptor().getDefaultFile().equals(file) ? null : file;
        }

        @Override
        public void bindToAncestor(Item o) {
            this.owner = o;
        }

        /*
         * Exception decompiling
         */
        @Override
        @Nonnull
        public String getContent() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Extension
        public static class DescriptorImpl
        extends KubeconfigSourceDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "From a file on the Kubernetes master node";
            }

            public String getDefaultFile() {
                return ".kube/config";
            }

            public ListBoxModel doFillSshCredentialIdItems(@AncestorInPath Item owner) {
                StandardListBoxModel model = new StandardListBoxModel();
                model.includeEmptyValue();
                model.includeAs(ACL.SYSTEM, owner, StandardUsernameCredentials.class);
                return model;
            }
        }
    }

    public static class FileOnMasterKubeconfigSource
    extends KubeconfigSource {
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterKubeconfigSource.class.getName());
        private final String kubeconfigFile;

        @DataBoundConstructor
        public FileOnMasterKubeconfigSource(String kubeconfigFile) {
            this.kubeconfigFile = kubeconfigFile;
        }

        @Override
        @Nonnull
        public String getContent() {
            File file;
            if (this.kubeconfigFile != null && (file = new File(this.kubeconfigFile)).isFile()) {
                try {
                    return FileUtils.readFileToString((File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("The kubeconfig file path is not configured");
        }

        public String getKubeconfigFile() {
            return this.kubeconfigFile;
        }

        @Extension
        public static class DescriptorImpl
        extends KubeconfigSourceDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "From a file on the Jenkins master";
            }
        }
    }

    public static class DirectEntryKubeconfigSource
    extends KubeconfigSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Secret content;

        @DataBoundConstructor
        public DirectEntryKubeconfigSource(String content) {
            this.content = Secret.fromString((String)content);
        }

        @Override
        @Nonnull
        public String getContent() {
            return Secret.toString((Secret)this.content);
        }

        @Override
        public boolean isSnapshotSource() {
            return true;
        }

        @Extension
        public static class DescriptorImpl
        extends KubeconfigSourceDescriptor {
            @Nonnull
            public String getDisplayName() {
                return "Enter directly";
            }
        }
    }

    public static abstract class KubeconfigSourceDescriptor
    extends Descriptor<KubeconfigSource> {
    }

    public static abstract class KubeconfigSource
    extends AbstractDescribableImpl<KubeconfigSource> {
        @Nonnull
        public abstract String getContent();

        public boolean isSnapshotSource() {
            return false;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return "Kubernetes configuration (kubeconfig)";
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public DescriptorExtensionList<KubeconfigSource, Descriptor<KubeconfigSource>> getKubeconfigSources() {
            return Jenkins.getInstance().getDescriptorList(KubeconfigSource.class);
        }
    }
}

