/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.command;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.CommandState;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.core.EnvironmentInjector;
import com.microsoft.jenkins.azurecommons.telemetry.AppInsightsUtils;
import com.microsoft.jenkins.kubernetes.KubernetesCDPlugin;
import com.microsoft.jenkins.kubernetes.Messages;
import com.microsoft.jenkins.kubernetes.credentials.ClientWrapperFactory;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import com.microsoft.jenkins.kubernetes.wrapper.KubernetesClientWrapper;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.ProxyException;
import hudson.util.VariableResolver;
import io.kubernetes.client.openapi.ApiClient;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.StringUtils;

public class DeploymentCommand
implements ICommand<IDeploymentCommand>,
Serializable {
    public void execute(IDeploymentCommand context) {
        JobContext jobContext = context.getJobContext();
        FilePath workspace = jobContext.getWorkspace();
        EnvVars envVars = context.getEnvVars();
        TaskResult taskResult = null;
        try {
            DeploymentTask task = new DeploymentTask();
            task.setWorkspace(workspace);
            task.setTaskListener(jobContext.getTaskListener());
            task.setClientFactory(context.clientFactory((Item)context.getJobContext().getRun().getParent()));
            task.setEnvVars(envVars);
            task.setConfigPaths(context.getConfigs());
            task.setSecretNamespace(context.getSecretNamespace());
            task.setSecretNameCfg(context.getSecretName());
            task.setDefaultSecretNameSeed(jobContext.getRun().getDisplayName());
            task.setEnableSubstitution(context.isEnableConfigSubstitution());
            task.setDockerRegistryEndpoints(context.resolveEndpoints((Item)jobContext.getRun().getParent()));
            task.setDeleteResource(context.isDeleteResource());
            taskResult = (TaskResult)workspace.act((Callable)task);
            for (Map.Entry entry : taskResult.extraEnvVars.entrySet()) {
                EnvironmentInjector.inject((Run)jobContext.getRun(), (EnvVars)envVars, (String)((String)entry.getKey()), entry.getValue());
            }
            context.setCommandState(taskResult.commandState);
            if (taskResult.commandState.isError()) {
                KubernetesCDPlugin.sendEvent("Kubernetes", "DeployFailed", "K8sMaster", AppInsightsUtils.hash((String)taskResult.masterHost));
            } else {
                KubernetesCDPlugin.sendEvent("Kubernetes", "Deployed", "K8sMaster", AppInsightsUtils.hash((String)taskResult.masterHost));
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            context.logError(e);
            KubernetesCDPlugin.sendEvent("Kubernetes", "DeployFailed", "K8sMaster", AppInsightsUtils.hash((String)(taskResult == null ? null : taskResult.masterHost)));
        }
    }

    @VisibleForTesting
    static String getMasterHost(KubernetesClientWrapper wrapper) {
        String url;
        ApiClient client;
        if (wrapper != null && (client = wrapper.getClient()) != null && (url = client.getBasePath()) != null) {
            return url;
        }
        return "Unknown";
    }

    public static interface IDeploymentCommand
    extends IBaseCommandData {
        public ClientWrapperFactory clientFactory(Item var1);

        public String getSecretNamespace();

        public String getSecretName();

        public List<ResolvedDockerRegistryEndpoint> resolveEndpoints(Item var1) throws IOException;

        public String getConfigs();

        public boolean isEnableConfigSubstitution();

        public boolean isDeleteResource();
    }

    public static class TaskResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CommandState commandState = CommandState.Unknown;
        private String masterHost;
        private final Map<String, String> extraEnvVars = new HashMap<String, String>();
    }

    static class DeploymentTask
    extends MasterToSlaveCallable<TaskResult, ProxyException> {
        private FilePath workspace;
        private TaskListener taskListener;
        private ClientWrapperFactory clientFactory;
        private EnvVars envVars;
        private String configPaths;
        private String secretNamespace;
        private String secretNameCfg;
        private String defaultSecretNameSeed;
        private boolean enableSubstitution;
        private boolean deleteResource;
        private List<ResolvedDockerRegistryEndpoint> dockerRegistryEndpoints;

        DeploymentTask() {
        }

        public TaskResult call() throws ProxyException {
            try {
                return this.doCall();
            }
            catch (Exception ex) {
                throw new ProxyException((Throwable)ex);
            }
        }

        private TaskResult doCall() throws Exception {
            TaskResult result = new TaskResult();
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.secretNamespace), (Object)Messages.DeploymentCommand_blankNamespace());
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.configPaths), (Object)Messages.DeploymentCommand_blankConfigFiles());
            KubernetesClientWrapper wrapper = this.clientFactory.buildClient(this.workspace).withLogger(this.taskListener.getLogger()).withDeleteResource(this.deleteResource);
            result.masterHost = DeploymentCommand.getMasterHost(wrapper);
            FilePath[] configFiles = this.workspace.list(this.configPaths);
            if (configFiles.length == 0) {
                String message = Messages.DeploymentCommand_noMatchingConfigFiles(this.configPaths);
                this.taskListener.error(message);
                result.commandState = CommandState.HasError;
                throw new IllegalStateException(message);
            }
            if (!this.dockerRegistryEndpoints.isEmpty()) {
                String secretName = KubernetesClientWrapper.prepareSecretName(this.secretNameCfg, this.defaultSecretNameSeed, this.envVars);
                wrapper.createOrReplaceSecrets(this.secretNamespace, secretName, this.dockerRegistryEndpoints);
                this.taskListener.getLogger().println(Messages.DeploymentCommand_injectSecretName("KUBERNETES_SECRET_NAME", secretName));
                this.envVars.put("KUBERNETES_SECRET_NAME", secretName);
                result.extraEnvVars.put("KUBERNETES_SECRET_NAME", secretName);
            }
            if (this.enableSubstitution) {
                wrapper.withVariableResolver((VariableResolver<String>)new VariableResolver.ByMap((Map)this.envVars));
            }
            wrapper.apply(configFiles);
            result.commandState = CommandState.Success;
            return result;
        }

        public void setWorkspace(FilePath workspace) {
            this.workspace = workspace;
        }

        public void setTaskListener(TaskListener taskListener) {
            this.taskListener = taskListener;
        }

        public void setClientFactory(ClientWrapperFactory clientFactory) {
            this.clientFactory = clientFactory;
        }

        public void setEnvVars(EnvVars envVars) {
            this.envVars = envVars;
        }

        public void setConfigPaths(String configPaths) {
            this.configPaths = configPaths;
        }

        public void setSecretNamespace(String secretNamespace) {
            this.secretNamespace = secretNamespace;
        }

        public void setSecretNameCfg(String secretNameCfg) {
            this.secretNameCfg = secretNameCfg;
        }

        public void setDefaultSecretNameSeed(String defaultSecretNameSeed) {
            this.defaultSecretNameSeed = defaultSecretNameSeed;
        }

        public void setEnableSubstitution(boolean enableSubstitution) {
            this.enableSubstitution = enableSubstitution;
        }

        public void setDockerRegistryEndpoints(List<ResolvedDockerRegistryEndpoint> dockerRegistryEndpoints) {
            this.dockerRegistryEndpoints = dockerRegistryEndpoints;
        }

        public void setDeleteResource(boolean isDeleteResource) {
            this.deleteResource = isDeleteResource;
        }
    }
}

