/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jobConfigHistory;

import hudson.FilePath;
import hudson.Util;
import hudson.XmlFile;
import hudson.maven.MavenModule;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.User;
import hudson.plugins.jobConfigHistory.DeletedFileFilter;
import hudson.plugins.jobConfigHistory.HistoryDao;
import hudson.plugins.jobConfigHistory.HistoryDescr;
import hudson.plugins.jobConfigHistory.HistoryFileFilter;
import hudson.plugins.jobConfigHistory.ItemListenerHistoryDao;
import hudson.plugins.jobConfigHistory.Messages;
import hudson.plugins.jobConfigHistory.NonDeletedFileFilter;
import hudson.plugins.jobConfigHistory.NonJobsDirectoryFileFilter;
import hudson.plugins.jobConfigHistory.OverviewHistoryDao;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class FileHistoryDao
implements HistoryDao,
ItemListenerHistoryDao,
OverviewHistoryDao {
    private static final Logger LOG = Logger.getLogger(FileHistoryDao.class.getName());
    private static final int CLASH_SLEEP_TIME = 500;
    private final File historyRootDir;
    private final File jenkinsHome;
    private final User currentUser;
    private final int maxHistoryEntries;
    private final boolean saveDuplicates;

    FileHistoryDao(File historyRootDir, File jenkinsHome, User currentUser, int maxHistoryEntries, boolean saveDuplicates) {
        this.historyRootDir = historyRootDir;
        this.jenkinsHome = jenkinsHome;
        this.currentUser = currentUser;
        this.maxHistoryEntries = maxHistoryEntries;
        this.saveDuplicates = saveDuplicates;
    }

    File getRootDir(XmlFile xmlFile, AtomicReference<Calendar> timestampHolder) {
        File configFile = xmlFile.getFile();
        File itemHistoryDir = this.getHistoryDir(configFile);
        this.purgeOldEntries(itemHistoryDir, this.maxHistoryEntries);
        return FileHistoryDao.createNewHistoryDir(itemHistoryDir, timestampHolder);
    }

    void createHistoryXmlFile(Calendar timestamp, File timestampedDir, String operation) throws IOException {
        String userId;
        String user;
        if (this.currentUser != null) {
            user = this.currentUser.getFullName();
            userId = this.currentUser.getId();
        } else {
            user = "Anonym";
            userId = Messages.ConfigHistoryListenerHelper_anonymous();
        }
        XmlFile historyDescription = this.getHistoryXmlFile(timestampedDir);
        HistoryDescr myDescr = new HistoryDescr(user, userId, operation, FileHistoryDao.getIdFormatter().format(timestamp.getTime()));
        historyDescription.write((Object)myDescr);
    }

    private XmlFile getHistoryXmlFile(File directory) {
        return new XmlFile(new File(directory, "history.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyConfigFile(File currentConfig, File timestampedDir) throws FileNotFoundException, IOException {
        BufferedOutputStream configCopy = new BufferedOutputStream(new FileOutputStream(new File(timestampedDir, currentConfig.getName())));
        try {
            FileInputStream configOriginal = new FileInputStream(currentConfig);
            try {
                Util.copyStream((InputStream)configOriginal, (OutputStream)configCopy);
            }
            finally {
                configOriginal.close();
            }
        }
        finally {
            configCopy.close();
        }
    }

    static SimpleDateFormat getIdFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    static File createNewHistoryDir(File itemHistoryDir, AtomicReference<Calendar> timestampHolder) {
        File f;
        GregorianCalendar timestamp;
        while (true) {
            timestamp = new GregorianCalendar();
            f = new File(itemHistoryDir, FileHistoryDao.getIdFormatter().format(timestamp.getTime()));
            if (!f.isDirectory()) break;
            LOG.log(Level.FINE, "clash on {0}, will wait a moment", f);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException x) {
                throw new RuntimeException(x);
            }
        }
        timestampHolder.set(timestamp);
        if (!f.mkdirs() && !f.exists()) {
            throw new RuntimeException("Could not create rootDir " + f);
        }
        return f;
    }

    @Override
    public void createNewItem(Item item) {
        AbstractItem aItem = (AbstractItem)item;
        this.createNewHistoryEntryAndCopyConfig(aItem.getConfigFile(), Messages.ConfigHistoryListenerHelper_CREATED());
    }

    void createNewHistoryEntryAndCopyConfig(XmlFile configFile, String operation) {
        File timestampedDir = this.createNewHistoryEntry(configFile, operation);
        try {
            FileHistoryDao.copyConfigFile(configFile.getFile(), timestampedDir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to copy " + configFile, ex);
        }
    }

    @Override
    public void saveItem(AbstractItem item) {
        this.saveItem(item.getConfigFile());
    }

    @Override
    public void saveItem(XmlFile file) {
        if (this.checkDuplicate(file)) {
            this.createNewHistoryEntryAndCopyConfig(file, Messages.ConfigHistoryListenerHelper_CHANGED());
        }
    }

    @Override
    public void deleteItem(Item item) {
        AbstractItem aItem = (AbstractItem)item;
        this.createNewHistoryEntry(aItem.getConfigFile(), Messages.ConfigHistoryListenerHelper_DELETED());
        File configFile = aItem.getConfigFile().getFile();
        File currentHistoryDir = this.getHistoryDir(configFile);
        SimpleDateFormat buildDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        String timestamp = buildDateFormat.format(new Date());
        String deletedHistoryName = item.getName() + "_deleted_" + timestamp;
        File deletedHistoryDir = new File(currentHistoryDir.getParentFile(), deletedHistoryName);
        if (!currentHistoryDir.renameTo(deletedHistoryDir)) {
            LOG.log(Level.WARNING, "unable to rename deleted history dir to: {0}", deletedHistoryDir);
        }
    }

    @Override
    public void renameItem(Item item, String oldName, String newName) {
        File configFile;
        File currentHistoryDir;
        File historyParentDir;
        File oldHistoryDir;
        AbstractItem aItem = (AbstractItem)item;
        String onRenameDesc = " old name: " + oldName + ", new name: " + newName;
        if (this.historyRootDir != null && (oldHistoryDir = new File(historyParentDir = (currentHistoryDir = this.getHistoryDir(configFile = aItem.getConfigFile().getFile())).getParentFile(), oldName)).exists()) {
            FilePath fp = new FilePath(oldHistoryDir);
            try {
                fp.copyRecursiveTo(new FilePath(currentHistoryDir));
                fp.deleteRecursive();
                LOG.log(Level.FINEST, "completed move of old history files on rename.{0}", onRenameDesc);
            }
            catch (IOException e) {
                String ioExceptionStr = "unable to move old history on rename." + onRenameDesc;
                LOG.log(Level.SEVERE, ioExceptionStr, e);
            }
            catch (InterruptedException e) {
                String irExceptionStr = "interrupted while moving old history on rename." + onRenameDesc;
                LOG.log(Level.WARNING, irExceptionStr, e);
            }
        }
        this.createNewHistoryEntryAndCopyConfig(aItem.getConfigFile(), Messages.ConfigHistoryListenerHelper_RENAMED());
    }

    @Override
    public SortedMap<String, HistoryDescr> getRevisions(XmlFile xmlFile) {
        return this.getRevisions(xmlFile.getFile());
    }

    @Override
    public SortedMap<String, HistoryDescr> getRevisions(File configFile) {
        File historiesDir = this.getHistoryDir(configFile);
        return this.getRevisions(historiesDir, configFile);
    }

    private SortedMap<String, HistoryDescr> getRevisions(File historiesDir, File configFile) {
        File[] historyDirsOfItem = historiesDir.listFiles(HistoryFileFilter.INSTANCE);
        TreeMap<String, HistoryDescr> map = new TreeMap<String, HistoryDescr>();
        if (historyDirsOfItem == null) {
            return map;
        }
        for (File historyDir : historyDirsOfItem) {
            HistoryDescr historyDescription;
            XmlFile historyXml = this.getHistoryXmlFile(historyDir);
            try {
                historyDescription = (HistoryDescr)historyXml.read();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read history for " + configFile, ex);
            }
            map.put(historyDir.getName(), historyDescription);
        }
        return map;
    }

    @Override
    public XmlFile getOldRevision(AbstractItem item, String identifier) {
        File configFile = item.getConfigFile().getFile();
        File historyDir = new File(this.getHistoryDir(configFile), identifier);
        if (item instanceof MavenModule) {
            String path = historyDir + ((MavenModule)item).getParent().getFullName().replace("/", "/jobs/") + "/modules/" + ((MavenModule)item).getModuleName().toFileSystemName() + "/" + identifier;
            return new XmlFile(FileHistoryDao.getConfigFile(new File(path)));
        }
        return new XmlFile(FileHistoryDao.getConfigFile(historyDir));
    }

    @Override
    public XmlFile getOldRevision(XmlFile xmlFile, String identifier) {
        File configFile = xmlFile.getFile();
        return this.getOldRevision(configFile, identifier);
    }

    @Override
    public XmlFile getOldRevision(File configFile, String identifier) {
        File historyDir = new File(this.getHistoryDir(configFile), identifier);
        return new XmlFile(FileHistoryDao.getConfigFile(historyDir));
    }

    @Override
    public XmlFile getOldRevision(String configFileName, String identifier) {
        File historyDir = new File(new File(this.historyRootDir, configFileName), identifier);
        File configFile = FileHistoryDao.getConfigFile(historyDir);
        if (configFile == null) {
            throw new IllegalArgumentException("Could not find " + historyDir);
        }
        return new XmlFile(configFile);
    }

    @Override
    public boolean hasOldRevision(AbstractItem item, String identifier) {
        return this.hasOldRevision(item.getConfigFile(), identifier);
    }

    @Override
    public boolean hasOldRevision(XmlFile xmlFile, String identifier) {
        return this.hasOldRevision(xmlFile.getFile(), identifier);
    }

    @Override
    public boolean hasOldRevision(File configFile, String identifier) {
        XmlFile oldRevision = this.getOldRevision(configFile, identifier);
        return oldRevision.getFile() != null && oldRevision.getFile().exists();
    }

    File createNewHistoryEntry(XmlFile xmlFile, String operation) {
        try {
            AtomicReference<Calendar> timestampHolder = new AtomicReference<Calendar>();
            File timestampedDir = this.getRootDir(xmlFile, timestampHolder);
            LOG.log(Level.FINE, "{0} on {1}", new Object[]{this, timestampedDir});
            this.createHistoryXmlFile(timestampHolder.get(), timestampedDir, operation);
            assert (timestampHolder.get() != null);
            return timestampedDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create history entry for configuration file: " + xmlFile.getFile().getAbsolutePath(), e);
        }
    }

    File getHistoryDir(File configFile) {
        File historyDir;
        String hudsonRootDir;
        String configRootDir = configFile.getParent();
        if (!configRootDir.startsWith(hudsonRootDir = this.jenkinsHome.getPath())) {
            throw new IllegalArgumentException("Trying to get history dir for object outside of HUDSON: " + configFile);
        }
        String underRootDir = null;
        if (configRootDir.equals(hudsonRootDir)) {
            String fileName = configFile.getName();
            underRootDir = fileName.substring(0, fileName.lastIndexOf(46));
        }
        if (underRootDir == null) {
            String remainingPath = configRootDir.substring(hudsonRootDir.length() + "jobs".length() + 1);
            historyDir = new File(this.getJobHistoryRootDir(), remainingPath);
        } else {
            historyDir = new File(this.historyRootDir, underRootDir);
        }
        return historyDir;
    }

    File getJobHistoryRootDir() {
        return new File(this.historyRootDir, "/jobs");
    }

    @Override
    public void purgeOldEntries(File itemHistoryRoot, int maxEntries) {
        if (maxEntries > 0) {
            LOG.log(Level.FINE, "checking for history files to purge ({0} max allowed)", maxEntries);
            int entriesToLeave = maxEntries - 1;
            File[] historyDirs = itemHistoryRoot.listFiles(HistoryFileFilter.INSTANCE);
            if (historyDirs != null && historyDirs.length >= entriesToLeave) {
                Arrays.sort(historyDirs, Collections.reverseOrder());
                for (int i = entriesToLeave; i < historyDirs.length; ++i) {
                    if (this.isCreatedEntry(historyDirs[i])) continue;
                    LOG.log(Level.FINE, "purging old directory from history logs: {0}", historyDirs[i]);
                    this.deleteDirectory(historyDirs[i]);
                }
            }
        }
    }

    @Override
    public boolean isCreatedEntry(File historyDir) {
        XmlFile historyXml = this.getHistoryXmlFile(historyDir);
        try {
            HistoryDescr histDescr = (HistoryDescr)historyXml.read();
            LOG.log(Level.FINEST, "historyDir: {0}", historyDir);
            LOG.log(Level.FINEST, "histDescr.getOperation(): {0}", histDescr.getOperation());
            if ("Created".equals(histDescr.getOperation())) {
                return true;
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINEST, "Unable to retrieve history file for {0}", historyDir);
        }
        return false;
    }

    private void deleteDirectory(File dir) {
        for (File file : dir.listFiles()) {
            if (file.delete()) continue;
            LOG.log(Level.WARNING, "problem deleting history file: {0}", file);
        }
        if (!dir.delete()) {
            LOG.log(Level.WARNING, "problem deleting history directory: {0}", dir);
        }
    }

    static File getConfigFile(File historyDir) {
        File configFile = null;
        if (HistoryFileFilter.accepts(historyDir)) {
            File[] listing;
            for (File file : listing = historyDir.listFiles()) {
                if (file.getName().equals("history.xml") || !file.getName().matches(".*\\.xml$")) continue;
                configFile = file;
            }
        }
        return configFile;
    }

    boolean hasDuplicateHistory(XmlFile xmlFile) {
        boolean isDuplicated = false;
        ArrayList<String> timeStamps = new ArrayList<String>(this.getRevisions(xmlFile).keySet());
        if (!timeStamps.isEmpty()) {
            Collections.sort(timeStamps, Collections.reverseOrder());
            XmlFile lastRevision = this.getOldRevision(xmlFile, timeStamps.get(0));
            try {
                if (xmlFile.asString().equals(lastRevision.asString())) {
                    isDuplicated = true;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "unable to check for duplicate previous history file: {0}\n{1}", new Object[]{lastRevision, e});
            }
        }
        return isDuplicated;
    }

    boolean checkDuplicate(XmlFile xmlFile) {
        if (!this.saveDuplicates && this.hasDuplicateHistory(xmlFile)) {
            LOG.log(Level.FINE, "found duplicate history, skipping save of {0}", xmlFile);
            return false;
        }
        return true;
    }

    @Override
    public File[] getDeletedJobs(String folderName) {
        return this.returnEmptyFileArrayForNull(new File(this.getJobHistoryRootDir(), folderName).listFiles(DeletedFileFilter.INSTANCE));
    }

    @Override
    public File[] getJobs(String folderName) {
        return this.returnEmptyFileArrayForNull(new File(this.getJobHistoryRootDir(), folderName).listFiles(NonDeletedFileFilter.INSTANCE));
    }

    @Override
    public File[] getSystemConfigs() {
        return this.returnEmptyFileArrayForNull(this.historyRootDir.listFiles(NonJobsDirectoryFileFilter.INSTANCE));
    }

    private File[] returnEmptyFileArrayForNull(File[] array) {
        if (array != null) {
            return array;
        }
        return new File[0];
    }

    @Override
    public SortedMap<String, HistoryDescr> getJobHistory(String jobName) {
        return this.getRevisions(new File(this.getJobHistoryRootDir(), jobName), new File(jobName));
    }

    @Override
    public SortedMap<String, HistoryDescr> getSystemHistory(String name) {
        return this.getRevisions(new File(this.historyRootDir, name), new File(name));
    }

    @Override
    public void copyHistoryAndDelete(String oldName, String newName) {
        File oldFile = new File(this.getJobHistoryRootDir(), oldName);
        File newFile = new File(this.getJobHistoryRootDir(), newName);
        try {
            FileUtils.copyDirectory((File)oldFile, (File)newFile);
            FileUtils.deleteDirectory((File)oldFile);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to move from " + oldFile + " to " + newFile, ex);
        }
    }
}

